/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.space;

import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.conditions.Conditions;
import io.tarantool.driver.api.cursor.OffsetCursor;
import io.tarantool.driver.api.cursor.TarantoolCursor;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.api.tuple.operations.TupleOperations;
import io.tarantool.driver.core.connection.TarantoolConnectionManager;
import io.tarantool.driver.core.space.TarantoolSpace;
import io.tarantool.driver.mappers.MessagePackValueMapper;

public class TarantoolTupleSpace
extends TarantoolSpace<TarantoolTuple, TarantoolResult<TarantoolTuple>> {
    private final TarantoolCallOperations client;
    private final TarantoolClientConfig config;

    public TarantoolTupleSpace(TarantoolCallOperations client, TarantoolClientConfig config, TarantoolConnectionManager connectionManager, TarantoolMetadataOperations metadataOperations, TarantoolSpaceMetadata spaceMetadata) {
        super(config, connectionManager, metadataOperations, spaceMetadata);
        this.client = client;
        this.config = config;
    }

    @Override
    protected TupleOperations makeOperationsFromTuple(TarantoolTuple tuple) {
        return TupleOperations.fromTarantoolTuple(tuple);
    }

    @Override
    protected MessagePackValueMapper tupleResultMapper() {
        return this.client.getResultMapperFactoryFactory().defaultTupleResultMapperFactory().withDefaultTupleValueConverter(this.config.getMessagePackMapper(), this.getMetadata());
    }

    @Override
    public String toString() {
        return String.format("TarantoolSpace %s [%d]", this.getMetadata().getSpaceName(), this.getMetadata().getSpaceId());
    }

    @Override
    public TarantoolCursor<TarantoolTuple> cursor(Conditions conditions, int batchSize) {
        return new OffsetCursor<TarantoolTuple, TarantoolResult<TarantoolTuple>>(this, conditions, batchSize);
    }

    @Override
    public TarantoolCursor<TarantoolTuple> cursor(Conditions conditions) {
        return this.cursor(conditions, this.config.getCursorBatchSize());
    }
}

