/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.tuple;

import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.tuple.TarantoolField;
import io.tarantool.driver.api.tuple.TarantoolNullField;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.core.tuple.TarantoolFieldImpl;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolSpaceFieldNotFoundException;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.utils.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.Consumer;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableArrayValue;
import org.msgpack.value.Value;

public class TarantoolTupleImpl
implements TarantoolTuple {
    private static final long serialVersionUID = 20200708L;
    private final TarantoolSpaceMetadata spaceMetadata;
    private final MessagePackMapper mapper;
    private transient ArrayList<TarantoolField> fields = new ArrayList();

    public TarantoolTupleImpl(MessagePackMapper mapper) {
        this(mapper, null);
    }

    public TarantoolTupleImpl(MessagePackMapper mapper, TarantoolSpaceMetadata metadata) {
        this(Collections.emptyList(), mapper, metadata);
    }

    public TarantoolTupleImpl(Collection<?> values, MessagePackMapper mapper) {
        this(values, mapper, null);
    }

    public TarantoolTupleImpl(Collection<?> values, MessagePackMapper mapper, TarantoolSpaceMetadata metadata) {
        Assert.notNull(mapper, "MessagePack mapper should not be null");
        this.mapper = mapper;
        this.spaceMetadata = metadata;
        if (values != null) {
            this.fields.ensureCapacity(values.size());
            for (Object value : values) {
                if (value == null) {
                    this.fields.add(new TarantoolNullField());
                    continue;
                }
                this.fields.add(new TarantoolFieldImpl(value));
            }
        }
    }

    public TarantoolTupleImpl(ArrayValue value, MessagePackMapper mapper) {
        this(value, mapper, null);
    }

    public TarantoolTupleImpl(ArrayValue value, MessagePackMapper mapper, TarantoolSpaceMetadata spaceMetadata) {
        Assert.notNull(mapper, "MessagePack mapper should not be null");
        this.mapper = mapper;
        this.spaceMetadata = spaceMetadata;
        if (value != null) {
            this.fields.ensureCapacity(value.size());
            for (Value fieldValue : value) {
                if (fieldValue.isNilValue()) {
                    this.fields.add(new TarantoolNullField());
                    continue;
                }
                this.fields.add(new TarantoolFieldImpl(fieldValue));
            }
        }
    }

    @Override
    public Optional<TarantoolField> getField(int fieldPosition) {
        Assert.state(fieldPosition >= 0, "Field position starts with 0");
        if (fieldPosition < this.fields.size()) {
            return Optional.ofNullable(this.fields.get(fieldPosition));
        }
        return Optional.empty();
    }

    @Override
    public Optional<TarantoolField> getField(String fieldName) {
        int fieldPosition = this.getFieldPositionByName(fieldName);
        if (fieldPosition < 0) {
            fieldPosition = Integer.MAX_VALUE;
        }
        return this.getField(fieldPosition);
    }

    @Override
    public List<TarantoolField> getFields() {
        return this.fields;
    }

    @Override
    public <O> Optional<O> getObject(int fieldPosition, Class<O> objectClass) {
        Optional<TarantoolField> field = this.getField(fieldPosition);
        return field.map(tarantoolField -> tarantoolField.getValue(objectClass, this.mapper));
    }

    @Override
    public boolean canGetObject(int fieldPosition, Class<?> objectClass) {
        Optional<TarantoolField> field = this.getField(fieldPosition);
        return field.map(tarantoolField -> tarantoolField.canConvertValue(objectClass, this.mapper)).orElse(false);
    }

    @Override
    public <O> Optional<O> getObject(String fieldName, Class<O> objectClass) {
        Optional<TarantoolField> field = this.getField(fieldName);
        return field.map(tarantoolField -> tarantoolField.getValue(objectClass, this.mapper));
    }

    @Override
    public boolean canGetObject(String fieldName, Class<?> objectClass) {
        Optional<TarantoolField> field = this.getField(fieldName);
        return field.map(tarantoolField -> tarantoolField.canConvertValue(objectClass, this.mapper)).orElse(false);
    }

    @Override
    public Optional<?> getObject(int fieldPosition) {
        Optional<TarantoolField> field = this.getField(fieldPosition);
        return field.map(tarantoolField -> tarantoolField.getValue(this.mapper));
    }

    @Override
    public Optional<?> getObject(String fieldName) {
        Optional<TarantoolField> field = this.getField(fieldName);
        return field.map(tarantoolField -> tarantoolField.getValue(this.mapper));
    }

    @Override
    public Iterator<TarantoolField> iterator() {
        return this.fields.iterator();
    }

    @Override
    public void forEach(Consumer<? super TarantoolField> action) {
        this.fields.forEach((Consumer<TarantoolField>)action);
    }

    @Override
    public Spliterator<TarantoolField> spliterator() {
        return this.fields.spliterator();
    }

    @Override
    public Value toMessagePackValue(MessagePackObjectMapper mapper) {
        return mapper.toValue(this.fields);
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public void setField(int fieldPosition, TarantoolField field) {
        if (fieldPosition < 0 || this.spaceMetadata != null && fieldPosition >= this.spaceMetadata.getSpaceFormatMetadata().size()) {
            throw new IndexOutOfBoundsException("Index: " + fieldPosition);
        }
        if (field == null) {
            field = new TarantoolNullField();
        }
        if (this.fields.size() < fieldPosition) {
            for (int i = this.fields.size(); i < fieldPosition; ++i) {
                this.fields.add(new TarantoolNullField());
            }
        }
        if (this.fields.size() == fieldPosition) {
            this.fields.add(fieldPosition, field);
        } else {
            this.fields.set(fieldPosition, field);
        }
    }

    @Override
    public void setField(String fieldName, TarantoolField field) {
        int fieldPosition = this.getFieldPositionByName(fieldName);
        if (fieldPosition < 0) {
            throw new TarantoolSpaceFieldNotFoundException(fieldName);
        }
        this.setField(fieldPosition, field);
    }

    @Override
    public void putObject(int fieldPosition, Object value) {
        TarantoolField tarantoolField = value == null ? new TarantoolNullField() : new TarantoolFieldImpl((Value)this.mapper.toValue(value));
        this.setField(fieldPosition, tarantoolField);
    }

    @Override
    public void putObject(String fieldName, Object value) {
        TarantoolField tarantoolField = value == null ? new TarantoolNullField() : new TarantoolFieldImpl((Value)this.mapper.toValue(value));
        this.setField(fieldName, tarantoolField);
    }

    @Override
    public byte[] getByteArray(int fieldPosition) {
        return this.getObject(fieldPosition, byte[].class).orElse(null);
    }

    @Override
    public byte[] getByteArray(String fieldName) {
        return this.getObject(fieldName, byte[].class).orElse(null);
    }

    @Override
    public Boolean getBoolean(int fieldPosition) {
        return this.getObject(fieldPosition, Boolean.class).orElse(null);
    }

    @Override
    public Boolean getBoolean(String fieldName) {
        return this.getObject(fieldName, Boolean.class).orElse(null);
    }

    @Override
    public Double getDouble(int fieldPosition) {
        return this.getObject(fieldPosition, Double.class).orElse(null);
    }

    @Override
    public Double getDouble(String fieldName) {
        return this.getObject(fieldName, Double.class).orElse(null);
    }

    @Override
    public Float getFloat(int fieldPosition) {
        return this.getObject(fieldPosition, Float.class).orElse(null);
    }

    @Override
    public Float getFloat(String fieldName) {
        return this.getObject(fieldName, Float.class).orElse(null);
    }

    @Override
    public Integer getInteger(int fieldPosition) {
        return this.getObject(fieldPosition, Integer.class).orElse(null);
    }

    @Override
    public Integer getInteger(String fieldName) {
        return this.getObject(fieldName, Integer.class).orElse(null);
    }

    @Override
    public Long getLong(int fieldPosition) {
        return this.getObject(fieldPosition, Long.class).orElse(null);
    }

    @Override
    public Long getLong(String fieldName) {
        return this.getObject(fieldName, Long.class).orElse(null);
    }

    @Override
    public String getString(int fieldPosition) {
        return this.getObject(fieldPosition, String.class).orElse(null);
    }

    @Override
    public String getString(String fieldName) {
        return this.getObject(fieldName, String.class).orElse(null);
    }

    @Override
    public Character getCharacter(int fieldPosition) {
        return this.getObject(fieldPosition, Character.class).orElse(null);
    }

    @Override
    public Character getCharacter(String fieldName) {
        return this.getObject(fieldName, Character.class).orElse(null);
    }

    @Override
    public UUID getUUID(int fieldPosition) {
        return this.getObject(fieldPosition, UUID.class).orElse(null);
    }

    @Override
    public UUID getUUID(String fieldName) {
        return this.getObject(fieldName, UUID.class).orElse(null);
    }

    @Override
    public BigDecimal getDecimal(int fieldPosition) {
        return this.getObject(fieldPosition, BigDecimal.class).orElse(null);
    }

    @Override
    public BigDecimal getDecimal(String fieldName) {
        return this.getObject(fieldName, BigDecimal.class).orElse(null);
    }

    @Override
    public List<?> getList(int fieldPosition) {
        return this.getObject(fieldPosition, List.class).orElse(null);
    }

    @Override
    public List<?> getList(String fieldName) {
        return this.getObject(fieldName, List.class).orElse(null);
    }

    @Override
    public Map<?, ?> getMap(int fieldPosition) {
        return this.getObject(fieldPosition, Map.class).orElse(null);
    }

    @Override
    public Map<?, ?> getMap(String fieldName) {
        return this.getObject(fieldName, Map.class).orElse(null);
    }

    protected int getFieldPositionByName(String fieldName) {
        int fieldPosition = -1;
        if (this.spaceMetadata != null) {
            fieldPosition = this.spaceMetadata.getFieldPositionByName(fieldName);
        }
        return fieldPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TarantoolTupleImpl)) {
            return false;
        }
        TarantoolTupleImpl that = (TarantoolTupleImpl)o;
        return Objects.equals(this.getFields(), that.getFields());
    }

    public int hashCode() {
        return Objects.hash(this.getFields());
    }

    private void writeObject(ObjectOutputStream out) {
        try {
            out.defaultWriteObject();
            MessagePacker packer = MessagePack.newDefaultPacker((OutputStream)out);
            packer.packValue(this.toMessagePackValue(this.mapper));
            packer.flush();
        }
        catch (IOException | MessagePackException e) {
            throw new TarantoolClientException("Failed to serialize tuple fields", e);
        }
    }

    private void readObject(ObjectInputStream in) {
        ImmutableArrayValue value;
        try {
            in.defaultReadObject();
            MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((InputStream)in);
            value = unpacker.unpackValue().asArrayValue();
        }
        catch (IOException | ClassNotFoundException | MessagePackException e) {
            throw new TarantoolClientException("Failed to deserialize tuple fields", e);
        }
        this.fields = new ArrayList(value.size());
        for (Value fieldValue : value) {
            if (fieldValue.isNilValue()) {
                this.fields.add(new TarantoolNullField());
                continue;
            }
            this.fields.add(new TarantoolFieldImpl(fieldValue));
        }
    }
}

