/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.exceptions.errors;

import io.tarantool.driver.exceptions.TarantoolAccessDeniedException;
import io.tarantool.driver.exceptions.TarantoolException;
import io.tarantool.driver.exceptions.TarantoolInternalException;
import io.tarantool.driver.exceptions.TarantoolInternalNetworkException;
import io.tarantool.driver.exceptions.TarantoolNoSuchProcedureException;
import io.tarantool.driver.exceptions.errors.BoxErrorKey;
import io.tarantool.driver.exceptions.errors.ErrorCode;
import io.tarantool.driver.exceptions.errors.ErrorKey;
import io.tarantool.driver.exceptions.errors.ErrorMessageBuilder;
import io.tarantool.driver.exceptions.errors.ErrorsErrorKey;
import io.tarantool.driver.exceptions.errors.TarantoolErrorFactory;
import io.tarantool.driver.protocol.TarantoolErrorResult;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.msgpack.value.Value;

public class TarantoolErrors {
    private static final String CLIENT_ERROR_TYPE = "ClientError";

    private static String getExceptionMessage(ErrorKey[] errorKeys, Map<Value, Value> errorMap) {
        return new ErrorMessageBuilder("InnerErrorMessage:", errorKeys, errorMap).build();
    }

    public static class TarantoolUnrecognizedErrorFactory
    implements TarantoolErrorFactory {
        @Override
        public Optional<TarantoolException> create(Value error) {
            String exceptionMessage = String.valueOf(error);
            return Optional.of(new TarantoolInternalException(exceptionMessage));
        }
    }

    public static class TarantoolBoxErrorFactory
    implements TarantoolErrorFactory {
        private static final long ERROR_INDICATOR_OFFSET = 32768L;

        @Override
        public Optional<TarantoolException> create(Value error) {
            if (error == null || !error.isMapValue()) {
                return Optional.empty();
            }
            Map errorMap = error.asMapValue().map();
            if (!this.isBoxError(errorMap).booleanValue()) {
                return Optional.empty();
            }
            String exceptionMessage = TarantoolErrors.getExceptionMessage(BoxErrorKey.values(), errorMap);
            if (this.isNetworkError(errorMap).booleanValue()) {
                return Optional.of(new TarantoolInternalNetworkException(exceptionMessage));
            }
            return Optional.of(new TarantoolInternalException(exceptionMessage));
        }

        public TarantoolException create(TarantoolErrorResult error) {
            Long code = error.getErrorCode() - 32768L;
            String message = error.getErrorMessage();
            StringBuilder sb = new StringBuilder("InnerErrorMessage:");
            sb.append("\n").append(BoxErrorKey.CODE.getKey()).append(": ").append(code);
            if (message != null) {
                sb.append("\n").append(BoxErrorKey.MESSAGE.getKey()).append(": ").append(message);
            }
            String exceptionMessage = sb.toString();
            if (this.isNetworkError(code).booleanValue()) {
                return new TarantoolInternalNetworkException(exceptionMessage);
            }
            if (ErrorCode.NO_SUCH_PROCEDURE.getCode().equals(code)) {
                return new TarantoolNoSuchProcedureException(exceptionMessage);
            }
            if (ErrorCode.ACCESS_DENIED.getCode().equals(code)) {
                return new TarantoolAccessDeniedException(exceptionMessage);
            }
            return new TarantoolInternalException(exceptionMessage);
        }

        private Boolean isNetworkError(Map<Value, Value> errorMap) {
            long code = errorMap.get(BoxErrorKey.CODE.getMsgPackKey()).asIntegerValue().asLong();
            String type = errorMap.get(BoxErrorKey.TYPE.getMsgPackKey()).toString();
            return (code == ErrorCode.NO_CONNECTION.getCode() || code == ErrorCode.TIMEOUT.getCode()) && type != null && type.equals(TarantoolErrors.CLIENT_ERROR_TYPE);
        }

        private Boolean isNetworkError(Long code) {
            return code.equals(ErrorCode.NO_CONNECTION.getCode()) || code.equals(ErrorCode.TIMEOUT.getCode());
        }

        private Boolean isBoxError(Map<Value, Value> errorMap) {
            return errorMap.containsKey(BoxErrorKey.CODE.getMsgPackKey()) && errorMap.containsKey(BoxErrorKey.MESSAGE.getMsgPackKey());
        }
    }

    public static class TarantoolErrorsErrorFactory
    implements TarantoolErrorFactory {
        private static final Pattern NETWORK_ERROR_PATTERN = Pattern.compile("(?=.*\"type\":\"ClientError\")(?=.*\"code\":[" + ErrorCode.NO_CONNECTION.getCode() + "|" + ErrorCode.TIMEOUT.getCode() + "])", 32);

        @Override
        public Optional<TarantoolException> create(Value error) {
            if (error == null || !error.isMapValue()) {
                return Optional.empty();
            }
            Map errorMap = error.asMapValue().map();
            if (!this.isErrorsError(errorMap).booleanValue()) {
                return Optional.empty();
            }
            String exceptionMessage = TarantoolErrors.getExceptionMessage(ErrorsErrorKey.values(), errorMap);
            if (this.isNetworkError(errorMap).booleanValue()) {
                return Optional.of(new TarantoolInternalNetworkException(exceptionMessage));
            }
            return Optional.of(new TarantoolInternalException(exceptionMessage));
        }

        private Boolean isNetworkError(Map<Value, Value> errorMap) {
            String err;
            String string = err = errorMap.containsKey(ErrorsErrorKey.ERR.getMsgPackKey()) ? errorMap.get(ErrorsErrorKey.ERR.getMsgPackKey()).toString() : null;
            if (err == null) {
                return false;
            }
            Matcher matcher = NETWORK_ERROR_PATTERN.matcher(err);
            return matcher.find();
        }

        private Boolean isErrorsError(Map<Value, Value> errorMap) {
            return errorMap.containsKey(ErrorsErrorKey.ERROR_MESSAGE.getMsgPackKey());
        }
    }
}

