/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.exceptions.errors;

import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolException;
import io.tarantool.driver.exceptions.errors.TarantoolErrorFactory;
import io.tarantool.driver.exceptions.errors.TarantoolErrors;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.msgpack.core.MessagePackException;
import org.msgpack.value.Value;

public final class TarantoolErrorsParser {
    private static final List<TarantoolErrorFactory> errorsFactories = Arrays.asList(new TarantoolErrors.TarantoolBoxErrorFactory(), new TarantoolErrors.TarantoolErrorsErrorFactory(), new TarantoolErrors.TarantoolUnrecognizedErrorFactory());

    private TarantoolErrorsParser() {
    }

    public static TarantoolException parse(Value error) {
        try {
            return errorsFactories.stream().map(factory -> factory.create(error)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new TarantoolClientException("Failed to parse internal error"));
        }
        catch (MessagePackException e) {
            throw new TarantoolClientException("Failed to unpack internal error", e);
        }
    }
}

