/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.handlers;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.tarantool.driver.core.RequestFutureManager;
import io.tarantool.driver.core.TarantoolRequestMetadata;
import io.tarantool.driver.exceptions.TarantoolDecoderException;
import io.tarantool.driver.exceptions.errors.TarantoolErrors;
import io.tarantool.driver.protocol.TarantoolErrorResult;
import io.tarantool.driver.protocol.TarantoolOkResult;
import io.tarantool.driver.protocol.TarantoolResponse;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarantoolResponseHandler
extends SimpleChannelInboundHandler<TarantoolResponse> {
    private final Logger log = LoggerFactory.getLogger(TarantoolResponseHandler.class);
    private final TarantoolErrors.TarantoolBoxErrorFactory boxErrorFactory = new TarantoolErrors.TarantoolBoxErrorFactory();
    private final RequestFutureManager futureManager;

    public TarantoolResponseHandler(RequestFutureManager futureManager) {
        this.futureManager = futureManager;
    }

    protected void channelRead0(ChannelHandlerContext ctx, TarantoolResponse tarantoolResponse) throws Exception {
        TarantoolRequestMetadata requestMeta = this.futureManager.getRequest(tarantoolResponse.getSyncId());
        if (requestMeta != null) {
            CompletableFuture<?> requestFuture = requestMeta.getFuture();
            if (!requestFuture.isDone()) {
                switch (tarantoolResponse.getResponseType()) {
                    case IPROTO_NOT_OK: {
                        TarantoolErrorResult errorResult = new TarantoolErrorResult(tarantoolResponse.getSyncId(), tarantoolResponse.getResponseCode(), tarantoolResponse.getBody().getData());
                        requestFuture.completeExceptionally(this.boxErrorFactory.create(errorResult));
                        break;
                    }
                    case IPROTO_OK: {
                        try {
                            TarantoolOkResult okResult = new TarantoolOkResult(tarantoolResponse.getSyncId(), tarantoolResponse.getBody().getData());
                            requestFuture.complete(requestMeta.getMapper().fromValue(okResult.getData()));
                            break;
                        }
                        catch (Throwable e) {
                            requestFuture.completeExceptionally(e);
                        }
                    }
                }
            }
        } else {
            this.log.info("Request {} is not registered in this client instance", (Object)tarantoolResponse.getSyncId());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        CompletableFuture<?> requestFuture;
        TarantoolDecoderException ex;
        TarantoolRequestMetadata requestMeta;
        if (cause instanceof DecoderException && cause.getCause() instanceof TarantoolDecoderException && (requestMeta = this.futureManager.getRequest((ex = (TarantoolDecoderException)cause.getCause()).getHeader().getSync())) != null && !(requestFuture = requestMeta.getFuture()).isDone()) {
            requestFuture.completeExceptionally(cause);
            return;
        }
        super.exceptionCaught(ctx, cause);
    }
}

