/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.api.MessagePackMapperBuilder;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.ConverterWrapper;
import io.tarantool.driver.mappers.InterfaceParameterClassNotFoundException;
import io.tarantool.driver.mappers.InterfaceParameterTypeNotFoundException;
import io.tarantool.driver.mappers.MapperReflectionUtils;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapperException;
import io.tarantool.driver.mappers.MessagePackValueMapperException;
import io.tarantool.driver.mappers.converters.ObjectConverter;
import io.tarantool.driver.mappers.converters.ValueConverter;
import io.tarantool.driver.mappers.converters.object.DefaultListToArrayValueConverter;
import io.tarantool.driver.mappers.converters.object.DefaultMapToMapValueConverter;
import io.tarantool.driver.mappers.converters.value.DefaultArrayValueToListConverter;
import io.tarantool.driver.mappers.converters.value.DefaultMapValueToMapConverter;
import io.tarantool.driver.mappers.converters.value.DefaultNullToNilValueConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.msgpack.value.NilValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;

public class DefaultMessagePackMapper
implements MessagePackMapper {
    private static final long serialVersionUID = 20220418L;
    private final Map<ValueType, List<ConverterWrapper<ValueConverter<? extends Value, ?>>>> valueConverters;
    private final Map<String, List<ConverterWrapper<ObjectConverter<?, ? extends Value>>>> objectConverters;
    private final ObjectConverter<Object, NilValue> nilConverter = new DefaultNullToNilValueConverter();

    public DefaultMessagePackMapper() {
        this.valueConverters = new HashMap();
        this.objectConverters = new HashMap();
    }

    public DefaultMessagePackMapper(DefaultMessagePackMapper mapper) {
        this();
        this.valueConverters.putAll(mapper.valueConverters);
        this.objectConverters.putAll(mapper.objectConverters);
    }

    private <V extends Value, O> ObjectConverter<O, V> getObjectConverter(O o, Function<String, Optional<ObjectConverter<O, V>>> getter) {
        if (o == null) {
            return this.nilConverter;
        }
        Optional converter = this.findObjectConverter(o.getClass(), getter);
        if (!converter.isPresent()) {
            throw new MessagePackObjectMapperException("ObjectConverter for type %s is not found", o.getClass());
        }
        return (ObjectConverter)converter.get();
    }

    @Override
    public <V extends Value, O> V toValue(O o) {
        Function<String, Optional<ObjectConverter<O, V>>> getter = typeName -> this.objectConverters.getOrDefault(typeName, Collections.emptyList()).stream().map(c -> (ObjectConverter)c.getConverter()).filter(c -> c.canConvertObject(o)).findFirst();
        ObjectConverter<O, V> converter = this.getObjectConverter(o, getter);
        return converter.toValue(o);
    }

    @Override
    public <V extends Value, O> O fromValue(V v) {
        Function<ValueType, Optional<ValueConverter<V, O>>> getter = typeName -> this.valueConverters.getOrDefault(typeName, Collections.emptyList()).stream().map(c -> (ValueConverter)c.getConverter()).filter(c -> c.canConvertValue(v)).findFirst();
        return this.fromValue(v, getter);
    }

    @Override
    public <V extends Value, O> O fromValue(V v, Class<O> targetClass) {
        Function<ValueType, Optional<ValueConverter<V, O>>> getter = typeName -> this.valueConverters.getOrDefault(typeName, Collections.emptyList()).stream().filter(c -> this.checkConverterByTargetType(c.getTargetClass(), targetClass)).map(c -> (ValueConverter)c.getConverter()).filter(c -> c.canConvertValue(v)).findFirst();
        return this.fromValue(v, getter);
    }

    private <V extends Value, O> O fromValue(V v, Function<ValueType, Optional<ValueConverter<V, O>>> getter) {
        Optional converter = this.findValueConverter(v.getValueType(), getter);
        if (!converter.isPresent()) {
            throw new MessagePackValueMapperException("ValueConverter for type %s is not found", v.getClass());
        }
        return ((ValueConverter)converter.get()).fromValue(v);
    }

    private <T> Optional<T> findObjectConverter(Class<?> objectClass, Function<String, Optional<T>> getter) {
        Optional<T> converter = getter.apply(objectClass.getTypeName());
        if (!converter.isPresent() && objectClass.getSuperclass() != null) {
            converter = this.findObjectConverter(objectClass.getSuperclass(), getter);
        }
        if (!converter.isPresent()) {
            Class<?> iface;
            Class<?>[] classArray = objectClass.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && !(converter = this.findObjectConverter(iface = classArray[i], getter)).isPresent(); ++i) {
            }
        }
        return converter;
    }

    private <T> Optional<T> findValueConverter(ValueType valueType, Function<ValueType, Optional<T>> getter) {
        return getter.apply(valueType);
    }

    public <V extends Value, O> void registerValueConverter(ValueType valueType, ValueConverter<V, ? extends O> converter) {
        try {
            Class objectClass = MapperReflectionUtils.getInterfaceParameterClass(converter, ValueConverter.class, 1);
            this.registerValueConverter(valueType, objectClass, converter);
        }
        catch (InterfaceParameterClassNotFoundException | InterfaceParameterTypeNotFoundException e) {
            throw new TarantoolClientException("Failed to determine the target parameter type of the generic interface, try to use the method registerValueConverter(valueClass, objectClass, converter) for registering the converter");
        }
    }

    @Override
    public <V extends Value, O> void registerValueConverter(ValueType valueType, Class<? extends O> objectClass, ValueConverter<V, ? extends O> converter) {
        List converters = this.valueConverters.computeIfAbsent(valueType, k -> new LinkedList());
        converters.add(0, new ConverterWrapper<ValueConverter<V, ? extends O>>(converter, objectClass));
    }

    private boolean checkConverterByTargetType(Class<?> targetClassOfConverter, Class<?> targetClass) {
        return targetClassOfConverter.isAssignableFrom(targetClass);
    }

    @Override
    public <V extends Value, O> Optional<ValueConverter<V, O>> getValueConverter(ValueType valueType, Class<O> targetClass) {
        Function getter = typeName -> this.valueConverters.getOrDefault(typeName, Collections.emptyList()).stream().filter(c -> this.checkConverterByTargetType(c.getTargetClass(), targetClass)).map(c -> (ValueConverter)c.getConverter()).findFirst();
        return this.findValueConverter(valueType, getter);
    }

    public <V extends Value, O> void registerObjectConverter(ObjectConverter<O, V> converter) {
        try {
            this.registerObjectConverter(MapperReflectionUtils.getInterfaceParameterClass(converter, ObjectConverter.class, 0), converter);
        }
        catch (InterfaceParameterClassNotFoundException | InterfaceParameterTypeNotFoundException e) {
            throw new TarantoolClientException("Failed to determine the target parameter type of the generic interface, try to use the method registerObjectConverter(objectClass, valueClass, converter) for registering the converter");
        }
    }

    public <V extends Value, O> void registerObjectConverter(Class<? extends O> objectClass, ObjectConverter<O, V> converter) {
        try {
            Class valueClass = MapperReflectionUtils.getInterfaceParameterClass(converter, ObjectConverter.class, 1);
            this.registerObjectConverter(objectClass, valueClass, converter);
        }
        catch (InterfaceParameterClassNotFoundException | InterfaceParameterTypeNotFoundException e) {
            throw new TarantoolClientException("Failed to determine the target parameter type of the generic interface, try to use the method registerObjectConverter(objectClass, valueClass, converter) for registering the converter");
        }
    }

    @Override
    public <V extends Value, O> void registerObjectConverter(Class<? extends O> objectClass, Class<V> valueClass, ObjectConverter<O, V> converter) {
        List converters = this.objectConverters.computeIfAbsent(objectClass.getTypeName(), k -> new LinkedList());
        converters.add(0, new ConverterWrapper<ObjectConverter<O, V>>(converter, valueClass));
    }

    @Override
    public <V extends Value, O> Optional<ObjectConverter<O, V>> getObjectConverter(Class<O> objectClass, Class<V> valueClass) {
        Function getter = typeName -> this.objectConverters.getOrDefault(typeName, Collections.emptyList()).stream().filter(c -> this.checkConverterByTargetType(c.getTargetClass(), valueClass)).map(c -> (ObjectConverter)c.getConverter()).findFirst();
        return this.findObjectConverter(objectClass, getter);
    }

    @Override
    public MessagePackMapper copy() {
        return new DefaultMessagePackMapper(this);
    }

    public static class Builder
    implements MessagePackMapperBuilder {
        private final DefaultMessagePackMapper mapper;

        public Builder() {
            this.mapper = new DefaultMessagePackMapper();
        }

        public Builder(DefaultMessagePackMapper mapper) {
            this.mapper = new DefaultMessagePackMapper(mapper);
        }

        @Override
        public Builder withDefaultMapValueConverter() {
            this.mapper.registerValueConverter(ValueType.MAP, new DefaultMapValueToMapConverter(this.mapper));
            return this;
        }

        @Override
        public Builder withDefaultMapObjectConverter() {
            this.mapper.registerObjectConverter(new DefaultMapToMapValueConverter(this.mapper));
            Class<HashMap> cls = HashMap.class;
            this.mapper.registerObjectConverter(cls, new DefaultMapToMapValueConverter(this.mapper));
            return this;
        }

        @Override
        public Builder withDefaultArrayValueConverter() {
            this.mapper.registerValueConverter(ValueType.ARRAY, new DefaultArrayValueToListConverter(this.mapper));
            return this;
        }

        @Override
        public Builder withDefaultListObjectConverter() {
            this.mapper.registerObjectConverter(new DefaultListToArrayValueConverter(this.mapper));
            Class<ArrayList> cls = ArrayList.class;
            this.mapper.registerObjectConverter(cls, new DefaultListToArrayValueConverter(this.mapper));
            return this;
        }

        @Override
        public <V extends Value, O> Builder withValueConverter(ValueType valueType, ValueConverter<V, O> converter) {
            this.mapper.registerValueConverter(valueType, converter);
            return this;
        }

        @Override
        public <V extends Value, O> Builder withValueConverter(ValueType valueType, Class<O> objectClass, ValueConverter<V, O> converter) {
            this.mapper.registerValueConverter(valueType, objectClass, converter);
            return this;
        }

        @Override
        public <V extends Value, O> Builder withObjectConverter(ObjectConverter<O, V> converter) {
            this.mapper.registerObjectConverter(converter);
            return this;
        }

        @Override
        public <V extends Value, O> Builder withObjectConverter(Class<O> objectClass, ObjectConverter<O, V> converter) {
            this.mapper.registerObjectConverter(objectClass, converter);
            return this;
        }

        @Override
        public <V extends Value, O> Builder withObjectConverter(Class<O> objectClass, Class<V> valueClass, ObjectConverter<O, V> converter) {
            this.mapper.registerObjectConverter(objectClass, valueClass, converter);
            return this;
        }

        @Override
        public DefaultMessagePackMapper build() {
            return this.mapper;
        }
    }
}

