/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers.converters.object;

import io.tarantool.driver.mappers.MessagePackValueMapperException;
import io.tarantool.driver.mappers.converters.ObjectConverter;
import java.io.IOException;
import java.math.BigDecimal;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.value.ExtensionValue;
import org.msgpack.value.ValueFactory;

public class DefaultBigDecimalToExtensionValueConverter
implements ObjectConverter<BigDecimal, ExtensionValue> {
    private static final long serialVersionUID = 20220418L;
    private static final byte DECIMAL_TYPE = 1;
    private static final int DECIMAL_MAX_DIGITS = 38;
    private static final byte DECIMAL_MINUS = 13;
    private static final byte DECIMAL_PLUS = 12;

    private byte[] toBytes(BigDecimal object) throws IOException {
        int scale = object.scale();
        if (scale > 38 || scale < -38) {
            throw new IOException(String.format("Scales with absolute value greater than %d are not supported", 38));
        }
        String number = object.unscaledValue().toString();
        int signum = 12;
        int digitsNum = number.length();
        int pos = 0;
        if (number.charAt(0) == '-') {
            signum = 13;
            --digitsNum;
            ++pos;
        }
        int len = (digitsNum >> 1) + 1;
        byte[] bcd = new byte[len];
        bcd[len - 1] = signum;
        char[] digits = number.substring(pos).toCharArray();
        pos = digits.length - 1;
        for (int i = len - 1; i > 0; --i) {
            int n = i;
            bcd[n] = (byte)(bcd[n] | Character.digit(digits[pos--], 10) << 4);
            int n2 = i - 1;
            bcd[n2] = (byte)(bcd[n2] | Character.digit(digits[pos--], 10));
        }
        if (pos == 0) {
            bcd[0] = (byte)(bcd[0] | Character.digit(digits[pos], 10) << 4);
        }
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        packer.packInt(scale);
        packer.writePayload(bcd);
        packer.close();
        return packer.toByteArray();
    }

    @Override
    public ExtensionValue toValue(BigDecimal object) {
        try {
            return ValueFactory.newExtension((byte)1, (byte[])this.toBytes(object));
        }
        catch (IOException e) {
            throw new MessagePackValueMapperException(String.format("Failed to pack BigDecimal %s to MessagePack entity", object), e);
        }
    }
}

