/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers.converters.object;

import io.tarantool.driver.mappers.converters.ObjectConverter;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.msgpack.value.ExtensionValue;
import org.msgpack.value.ValueFactory;

public class DefaultUUIDToExtensionValueConverter
implements ObjectConverter<UUID, ExtensionValue> {
    private static final long serialVersionUID = 20220418L;
    private static final byte UUID_TYPE = 2;

    private byte[] toBytes(UUID value) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        long mostSignificant = value.getMostSignificantBits();
        buffer.putInt((int)(mostSignificant >>> 32)).putShort((short)((mostSignificant & 0xFFFFFFFFL) >>> 16)).putShort((short)(mostSignificant & 0xFFFFL));
        long leastSignificant = value.getLeastSignificantBits();
        buffer.put((byte)(leastSignificant >>> 56)).put((byte)((leastSignificant & 0xFF000000000000L) >>> 48)).put((byte)((leastSignificant & 0xFF0000000000L) >>> 40)).put((byte)((leastSignificant & 0xFF00000000L) >>> 32)).put((byte)((leastSignificant & 0xFF000000L) >>> 24)).put((byte)((leastSignificant & 0xFF0000L) >>> 16)).put((byte)((leastSignificant & 0xFF00L) >>> 8)).put((byte)(leastSignificant & 0xFFL));
        return buffer.array();
    }

    @Override
    public ExtensionValue toValue(UUID object) {
        return ValueFactory.newExtension((byte)2, (byte[])this.toBytes(object));
    }
}

