/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers.converters.value;

import io.tarantool.driver.mappers.converters.ValueConverter;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.msgpack.value.ExtensionValue;

public class DefaultExtensionValueToUUIDConverter
implements ValueConverter<ExtensionValue, UUID> {
    private static final long serialVersionUID = 20220418L;
    private static final byte UUID_TYPE = 2;

    private UUID fromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long mostSignificant = ((long)buffer.getInt() & 0xFFFFFFFFL) << 32 | ((long)buffer.getShort() & 0xFFFFL) << 16 | (long)buffer.getShort() & 0xFFFFL;
        long leastSignificant = ((long)buffer.get() & 0xFFL) << 56 | ((long)buffer.get() & 0xFFL) << 48 | ((long)buffer.get() & 0xFFL) << 40 | ((long)buffer.get() & 0xFFL) << 32 | ((long)buffer.get() & 0xFFL) << 24 | ((long)buffer.get() & 0xFFL) << 16 | ((long)buffer.get() & 0xFFL) << 8 | (long)buffer.get() & 0xFFL;
        return new UUID(mostSignificant, leastSignificant);
    }

    @Override
    public UUID fromValue(ExtensionValue value) {
        return this.fromBytes(value.getData());
    }

    @Override
    public boolean canConvertValue(ExtensionValue value) {
        return value.getType() == 2;
    }
}

