/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol;

import io.tarantool.driver.protocol.TarantoolProtocolException;
import org.msgpack.value.Value;

public class TarantoolErrorResult {
    private final Long syncId;
    private final Long errorCode;
    private final String errorMessage;

    public TarantoolErrorResult(Long syncId, Long errorCode, Value body) throws TarantoolProtocolException {
        this.syncId = syncId;
        this.errorCode = errorCode;
        if (!body.isStringValue()) {
            throw new TarantoolProtocolException("Error body is not a MP_STRING value: {}", body.toJson());
        }
        this.errorMessage = body.asStringValue().toString();
    }

    public Long getSyncId() {
        return this.syncId;
    }

    public Long getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

