/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol;

import io.tarantool.driver.protocol.TarantoolIteratorType;
import io.tarantool.driver.utils.Assert;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TarantoolIndexQuery {
    public static final int PRIMARY = 0;
    private int indexId = 0;
    private TarantoolIteratorType iteratorType = TarantoolIteratorType.defaultIterator();
    private List<?> keyValues = Collections.emptyList();

    public TarantoolIndexQuery() {
    }

    public TarantoolIndexQuery(int indexId) {
        Assert.state(indexId >= 0, "Index ID must be greater than or equal to 0");
        this.indexId = indexId;
    }

    public int getIndexId() {
        return this.indexId;
    }

    public TarantoolIteratorType getIteratorType() {
        return this.iteratorType;
    }

    public TarantoolIndexQuery withIteratorType(TarantoolIteratorType iteratorType) {
        this.iteratorType = iteratorType;
        return this;
    }

    public List<?> getKeyValues() {
        return this.keyValues;
    }

    public TarantoolIndexQuery withKeyValues(List<?> keyValues) {
        Assert.notNull(keyValues, "Key values must not be null");
        this.keyValues = keyValues;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TarantoolIndexQuery that = (TarantoolIndexQuery)o;
        return this.getIndexId() == that.getIndexId() && this.getIteratorType() == that.getIteratorType() && this.getKeyValues().equals(that.getKeyValues());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getIndexId(), this.getIteratorType(), this.getKeyValues()});
    }

    public String toString() {
        return "TarantoolIndexQuery{indexId=" + this.indexId + ", iteratorType=" + (Object)((Object)this.iteratorType) + ", keyValues=" + this.keyValues + '}';
    }
}

