/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol.requests;

import io.tarantool.driver.auth.TarantoolAuthMechanism;
import io.tarantool.driver.mappers.DefaultMessagePackMapper;
import io.tarantool.driver.mappers.DefaultMessagePackMapperFactory;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequest;
import io.tarantool.driver.protocol.TarantoolRequestBody;
import io.tarantool.driver.protocol.TarantoolRequestType;
import io.tarantool.driver.utils.Assert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class TarantoolAuthRequest
extends TarantoolRequest {
    private static final int IPROTO_USER_NAME = 35;
    private static final int IPROTO_AUTH_DATA = 33;

    private TarantoolAuthRequest(TarantoolRequestBody body) {
        super(TarantoolRequestType.IPROTO_AUTH, body);
    }

    public static class Builder {
        private Map<Integer, Object> authMap = new HashMap<Integer, Object>(2, 1.0f);

        public Builder withUsername(String username) {
            Assert.hasText(username, "Username must not be empty");
            this.authMap.put(35, username);
            return this;
        }

        public Builder withAuthData(TarantoolAuthMechanism authMechanism, byte[] authData) {
            Assert.notNull(authData, "Username must not be empty");
            this.authMap.put(33, Arrays.asList(authMechanism.getSignature(), authData));
            return this;
        }

        public TarantoolAuthRequest build() throws TarantoolProtocolException {
            if (this.authMap.size() < 2) {
                throw new TarantoolProtocolException("Username and auth data must be specified for Tarantool auth request");
            }
            DefaultMessagePackMapper mapper = DefaultMessagePackMapperFactory.getInstance().defaultComplexTypesMapper();
            return new TarantoolAuthRequest(new TarantoolRequestBody(this.authMap, mapper));
        }
    }
}

