/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol.requests;

import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequest;
import io.tarantool.driver.protocol.TarantoolRequestBody;
import io.tarantool.driver.protocol.TarantoolRequestFieldType;
import io.tarantool.driver.protocol.TarantoolRequestType;
import java.util.HashMap;
import java.util.Map;

public final class TarantoolInsertRequest
extends TarantoolRequest {
    private TarantoolInsertRequest(TarantoolRequestBody body) {
        super(TarantoolRequestType.IPROTO_INSERT, body);
    }

    public static class Builder {
        Map<Integer, Object> bodyMap = new HashMap<Integer, Object>(2, 1.0f);

        public Builder withSpaceId(int spaceId) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_SPACE_ID.getCode(), spaceId);
            return this;
        }

        public Builder withTuple(Packable tuple) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_TUPLE.getCode(), tuple);
            return this;
        }

        public TarantoolInsertRequest build(MessagePackObjectMapper mapper) throws TarantoolProtocolException {
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_SPACE_ID.getCode())) {
                throw new TarantoolProtocolException("Space ID must be specified in the insert request");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_TUPLE.getCode())) {
                throw new TarantoolProtocolException("Tuple value must be specified for the insert request");
            }
            return new TarantoolInsertRequest(new TarantoolRequestBody(this.bodyMap, mapper));
        }
    }
}

