/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol.requests;

import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.TarantoolIteratorType;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequest;
import io.tarantool.driver.protocol.TarantoolRequestBody;
import io.tarantool.driver.protocol.TarantoolRequestFieldType;
import io.tarantool.driver.protocol.TarantoolRequestType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TarantoolSelectRequest
extends TarantoolRequest {
    private TarantoolSelectRequest(TarantoolRequestBody body) {
        super(TarantoolRequestType.IPROTO_SELECT, body);
    }

    public static class Builder {
        Map<Integer, Object> bodyMap = new HashMap<Integer, Object>(6, 1.0f);

        public Builder withSpaceId(int spaceId) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_SPACE_ID.getCode(), spaceId);
            return this;
        }

        public Builder withIndexId(int indexId) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_INDEX_ID.getCode(), indexId);
            return this;
        }

        public Builder withLimit(long limit) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_LIMIT.getCode(), limit);
            return this;
        }

        public Builder withOffset(long offset) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_OFFSET.getCode(), offset);
            return this;
        }

        public Builder withIteratorType(TarantoolIteratorType iteratorType) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_ITERATOR.getCode(), iteratorType.getCode());
            return this;
        }

        public Builder withKeyValues(List<?> keyValues) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_KEY.getCode(), keyValues);
            return this;
        }

        public TarantoolSelectRequest build(MessagePackObjectMapper mapper) throws TarantoolProtocolException {
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_SPACE_ID.getCode())) {
                throw new TarantoolProtocolException("Space ID must be specified in the select request");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_INDEX_ID.getCode())) {
                throw new TarantoolProtocolException("Index ID must be specified in the select request");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_OFFSET.getCode())) {
                throw new TarantoolProtocolException("Offset must be specified in the select request");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_LIMIT.getCode())) {
                throw new TarantoolProtocolException("Limit must be specified in the select request");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_ITERATOR.getCode())) {
                throw new TarantoolProtocolException("Iterator type must be specified in the select request");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_KEY.getCode())) {
                throw new TarantoolProtocolException("Key values must be specified in the select request");
            }
            return new TarantoolSelectRequest(new TarantoolRequestBody(this.bodyMap, mapper));
        }
    }
}

