/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.cluster;

import io.tarantool.driver.cluster.TarantoolClusterDiscoveryEndpoint;
import io.tarantool.driver.utils.Assert;

public class HTTPClusterDiscoveryEndpoint
implements TarantoolClusterDiscoveryEndpoint {
    private String uri;
    private int connectTimeout = 1000;
    private int readTimeout = 1000;

    public HTTPClusterDiscoveryEndpoint() {
    }

    public HTTPClusterDiscoveryEndpoint(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final HTTPClusterDiscoveryEndpoint endpoint = new HTTPClusterDiscoveryEndpoint();

        public Builder withURI(String uri) {
            Assert.hasText(uri, "The discovery endpoint URI should not be null or empty");
            this.endpoint.setUri(uri);
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            if (connectTimeout <= 0) {
                throw new IllegalArgumentException("Connect timeout must be greater or equal than 0 ms");
            }
            this.endpoint.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            if (readTimeout <= 0) {
                throw new IllegalArgumentException("Read timeout must be greater or equal than 0 ms");
            }
            this.endpoint.setReadTimeout(readTimeout);
            return this;
        }

        public HTTPClusterDiscoveryEndpoint build() {
            return this.endpoint;
        }
    }
}

