/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.tarantool.driver.TarantoolVersionHolder;
import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.auth.ChapSha1TarantoolAuthenticator;
import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.codecs.MessagePackFrameDecoder;
import io.tarantool.driver.codecs.MessagePackFrameEncoder;
import io.tarantool.driver.core.RequestFutureManager;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.handlers.TarantoolAuthenticationHandler;
import io.tarantool.driver.handlers.TarantoolAuthenticationResponseHandler;
import io.tarantool.driver.handlers.TarantoolRequestHandler;
import io.tarantool.driver.handlers.TarantoolResponseHandler;
import io.tarantool.driver.mappers.DefaultMessagePackMapperFactory;
import java.util.concurrent.CompletableFuture;

public class TarantoolChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final TarantoolClientConfig config;
    private final TarantoolVersionHolder versionHolder;
    private final CompletableFuture<Channel> connectionFuture;
    private final RequestFutureManager futureManager;

    public TarantoolChannelInitializer(TarantoolClientConfig config, RequestFutureManager futureManager, TarantoolVersionHolder versionHolder, CompletableFuture<Channel> connectionFuture) {
        this.config = config;
        this.versionHolder = versionHolder;
        this.connectionFuture = connectionFuture;
        this.futureManager = futureManager;
    }

    protected void initChannel(SocketChannel socketChannel) {
        ChannelPipeline pipeline = socketChannel.pipeline();
        if (this.config.isSecure()) {
            this.wrapForSecure(socketChannel, pipeline);
        }
        pipeline.addLast("TarantoolAuthenticationHandler", new TarantoolAuthenticationHandler<SimpleTarantoolCredentials, ChapSha1TarantoolAuthenticator>(this.connectionFuture, this.versionHolder, (SimpleTarantoolCredentials)this.config.getCredentials(), new ChapSha1TarantoolAuthenticator())).addLast("MessagePackFrameDecoder", (ChannelHandler)new MessagePackFrameDecoder()).addLast("MessagePackFrameEncoder", (ChannelHandler)new MessagePackFrameEncoder(DefaultMessagePackMapperFactory.getInstance().defaultComplexTypesMapper())).addLast("TarantoolRequestHandler", (ChannelHandler)new TarantoolRequestHandler(this.futureManager)).addLast("TarantoolAuthenticationResponseHandler", (ChannelHandler)new TarantoolAuthenticationResponseHandler(this.connectionFuture)).addLast("TarantoolResponseHandler", (ChannelHandler)new TarantoolResponseHandler(this.futureManager));
    }

    private void wrapForSecure(SocketChannel socketChannel, ChannelPipeline pipeline) {
        SslContext sslContext = this.config.getSslContext();
        if (sslContext == null) {
            throw new TarantoolClientException("Ssl context must not be null!");
        }
        pipeline.addLast(new ChannelHandler[]{sslContext.newHandler(socketChannel.alloc())});
    }
}

