/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.proxy;

import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.TarantoolVoidResult;
import io.tarantool.driver.api.space.options.OperationWithTimeoutOptions;
import io.tarantool.driver.core.proxy.AbstractProxyOperation;
import io.tarantool.driver.core.proxy.CRUDBaseOptions;
import io.tarantool.driver.core.proxy.ProxyOperation;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class TruncateProxyOperation
implements ProxyOperation<Void> {
    private final TarantoolCallOperations client;
    private final String functionName;
    private final List<?> arguments;

    private TruncateProxyOperation(TarantoolCallOperations client, String functionName, List<?> arguments) {
        this.client = client;
        this.arguments = arguments;
        this.functionName = functionName;
    }

    public TarantoolCallOperations getClient() {
        return this.client;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<?> getArguments() {
        return this.arguments;
    }

    @Override
    public CompletableFuture<Void> execute() {
        return this.client.callForSingleResult(this.functionName, this.arguments, Boolean.class).thenApply(v -> (Void)TarantoolVoidResult.INSTANCE.value());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractProxyOperation.GenericOperationsBuilder<Void, OperationWithTimeoutOptions, Builder> {
        @Override
        Builder self() {
            return this;
        }

        public TruncateProxyOperation build() {
            CRUDBaseOptions requestOptions = ((CRUDBaseOptions.Builder)new CRUDBaseOptions.Builder().withTimeout(((OperationWithTimeoutOptions)this.options).getTimeout())).build();
            List<Object> arguments = Arrays.asList(this.spaceName, requestOptions.asMap());
            return new TruncateProxyOperation(this.client, this.functionName, arguments);
        }
    }
}

