/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.space;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.conditions.Conditions;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.proxy.ProxyOperationsMappingConfig;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.api.space.options.DeleteOptions;
import io.tarantool.driver.api.space.options.InsertManyOptions;
import io.tarantool.driver.api.space.options.InsertOptions;
import io.tarantool.driver.api.space.options.ReplaceManyOptions;
import io.tarantool.driver.api.space.options.ReplaceOptions;
import io.tarantool.driver.api.space.options.SelectOptions;
import io.tarantool.driver.api.space.options.UpdateOptions;
import io.tarantool.driver.api.space.options.UpsertOptions;
import io.tarantool.driver.api.space.options.proxy.ProxyDeleteOptions;
import io.tarantool.driver.api.space.options.proxy.ProxyInsertManyOptions;
import io.tarantool.driver.api.space.options.proxy.ProxyInsertOptions;
import io.tarantool.driver.api.space.options.proxy.ProxyReplaceManyOptions;
import io.tarantool.driver.api.space.options.proxy.ProxyReplaceOptions;
import io.tarantool.driver.api.space.options.proxy.ProxySelectOptions;
import io.tarantool.driver.api.space.options.proxy.ProxyTruncateOptions;
import io.tarantool.driver.api.space.options.proxy.ProxyUpdateOptions;
import io.tarantool.driver.api.space.options.proxy.ProxyUpsertOptions;
import io.tarantool.driver.api.tuple.operations.TupleOperations;
import io.tarantool.driver.core.proxy.DeleteProxyOperation;
import io.tarantool.driver.core.proxy.InsertManyProxyOperation;
import io.tarantool.driver.core.proxy.InsertProxyOperation;
import io.tarantool.driver.core.proxy.ProxyOperation;
import io.tarantool.driver.core.proxy.ReplaceManyProxyOperation;
import io.tarantool.driver.core.proxy.ReplaceProxyOperation;
import io.tarantool.driver.core.proxy.SelectProxyOperation;
import io.tarantool.driver.core.proxy.TruncateProxyOperation;
import io.tarantool.driver.core.proxy.UpdateProxyOperation;
import io.tarantool.driver.core.proxy.UpsertProxyOperation;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.protocol.TarantoolIndexQuery;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public abstract class ProxyTarantoolSpace<T extends Packable, R extends Collection<T>>
implements TarantoolSpaceOperations<T, R> {
    private final String spaceName;
    private final TarantoolClientConfig config;
    private final TarantoolCallOperations client;
    private final TarantoolMetadataOperations metadataOperations;
    private final ProxyOperationsMappingConfig operationsMapping;
    private final TarantoolSpaceMetadata spaceMetadata;

    public ProxyTarantoolSpace(TarantoolClientConfig config, TarantoolCallOperations client, ProxyOperationsMappingConfig operationsMapping, TarantoolMetadataOperations metadata, TarantoolSpaceMetadata spaceMetadata) {
        this.config = config;
        this.client = client;
        this.operationsMapping = operationsMapping;
        this.metadataOperations = metadata;
        this.spaceMetadata = spaceMetadata;
        this.spaceName = spaceMetadata.getSpaceName();
    }

    @Override
    public CompletableFuture<R> delete(Conditions conditions) throws TarantoolClientException {
        return this.delete(conditions, this.tupleResultMapper(), (DeleteOptions)ProxyDeleteOptions.create().withTimeout(this.config.getRequestTimeout()));
    }

    @Override
    public CompletableFuture<R> delete(Conditions conditions, DeleteOptions options) throws TarantoolClientException {
        if (options == null) {
            throw new IllegalArgumentException("Options should not be null");
        }
        return this.delete(conditions, this.tupleResultMapper(), options);
    }

    private CompletableFuture<R> delete(Conditions conditions, CallResultMapper<R, SingleValueCallResult<R>> resultMapper, DeleteOptions options) throws TarantoolClientException {
        TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
        DeleteProxyOperation operation = ((DeleteProxyOperation.Builder)((DeleteProxyOperation.Builder)((DeleteProxyOperation.Builder)((DeleteProxyOperation.Builder)((DeleteProxyOperation.Builder)((DeleteProxyOperation.Builder)new DeleteProxyOperation.Builder().withClient(this.client)).withSpaceName(this.spaceName)).withFunctionName(this.operationsMapping.getDeleteFunctionName())).withIndexQuery(indexQuery).withArgumentsMapper(this.config.getMessagePackMapper())).withResultMapper(resultMapper)).withOptions(options)).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> insert(T tuple) throws TarantoolClientException {
        return this.insert(tuple, this.tupleResultMapper(), (InsertOptions)ProxyInsertOptions.create().withTimeout(this.config.getRequestTimeout()));
    }

    @Override
    public CompletableFuture<R> insert(T tuple, InsertOptions options) throws TarantoolClientException {
        if (options == null) {
            throw new IllegalArgumentException("Options should not be null");
        }
        return this.insert(tuple, this.tupleResultMapper(), options);
    }

    private CompletableFuture<R> insert(T tuple, CallResultMapper<R, SingleValueCallResult<R>> resultMapper, InsertOptions options) throws TarantoolClientException {
        InsertProxyOperation operation = ((InsertProxyOperation.Builder)((InsertProxyOperation.Builder)((InsertProxyOperation.Builder)((InsertProxyOperation.Builder)((InsertProxyOperation.Builder)((InsertProxyOperation.Builder)new InsertProxyOperation.Builder().withClient(this.client)).withSpaceName(this.spaceName)).withFunctionName(this.operationsMapping.getInsertFunctionName())).withTuple(tuple).withArgumentsMapper(this.config.getMessagePackMapper())).withResultMapper(resultMapper)).withOptions(options)).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> insertMany(Collection<T> tuples) {
        return this.insertMany(tuples, this.tupleResultMapper(), ((ProxyInsertManyOptions)ProxyInsertManyOptions.create().withTimeout(this.config.getRequestTimeout())).withStopOnError(true).withRollbackOnError(true));
    }

    @Override
    public CompletableFuture<R> insertMany(Collection<T> tuples, InsertManyOptions options) throws TarantoolClientException {
        if (options == null) {
            throw new IllegalArgumentException("Options should not be null");
        }
        return this.insertMany(tuples, this.tupleResultMapper(), options);
    }

    private CompletableFuture<R> insertMany(Collection<T> tuples, CallResultMapper<R, SingleValueCallResult<R>> resultMapper, InsertManyOptions options) throws TarantoolClientException {
        InsertManyProxyOperation operation = ((InsertManyProxyOperation.Builder)((InsertManyProxyOperation.Builder)((InsertManyProxyOperation.Builder)((InsertManyProxyOperation.Builder)((InsertManyProxyOperation.Builder)((InsertManyProxyOperation.Builder)new InsertManyProxyOperation.Builder().withClient(this.client)).withSpaceName(this.spaceName)).withFunctionName(this.operationsMapping.getInsertManyFunctionName())).withTuples(tuples).withArgumentsMapper(this.config.getMessagePackMapper())).withResultMapper(resultMapper)).withOptions(options)).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> replace(T tuple) throws TarantoolClientException {
        return this.replace(tuple, this.tupleResultMapper(), (ReplaceOptions)ProxyReplaceOptions.create().withTimeout(this.config.getRequestTimeout()));
    }

    @Override
    public CompletableFuture<R> replace(T tuple, ReplaceOptions options) throws TarantoolClientException {
        if (options == null) {
            throw new IllegalArgumentException("Options should not be null");
        }
        return this.replace(tuple, this.tupleResultMapper(), options);
    }

    private CompletableFuture<R> replace(T tuple, CallResultMapper<R, SingleValueCallResult<R>> resultMapper, ReplaceOptions options) throws TarantoolClientException {
        ReplaceProxyOperation operation = ((ReplaceProxyOperation.Builder)((ReplaceProxyOperation.Builder)((ReplaceProxyOperation.Builder)((ReplaceProxyOperation.Builder)((ReplaceProxyOperation.Builder)((ReplaceProxyOperation.Builder)new ReplaceProxyOperation.Builder().withClient(this.client)).withSpaceName(this.spaceName)).withFunctionName(this.operationsMapping.getReplaceFunctionName())).withTuple(tuple).withArgumentsMapper(this.config.getMessagePackMapper())).withResultMapper(resultMapper)).withOptions(options)).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> replaceMany(Collection<T> tuples) throws TarantoolClientException {
        return this.replaceMany(tuples, this.tupleResultMapper(), ((ProxyReplaceManyOptions)ProxyReplaceManyOptions.create().withTimeout(this.config.getRequestTimeout())).withStopOnError(true).withRollbackOnError(true));
    }

    @Override
    public CompletableFuture<R> replaceMany(Collection<T> tuples, ReplaceManyOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Options should not be null");
        }
        return this.replaceMany(tuples, this.tupleResultMapper(), options);
    }

    private CompletableFuture<R> replaceMany(Collection<T> tuples, CallResultMapper<R, SingleValueCallResult<R>> resultMapper, ReplaceManyOptions options) throws TarantoolClientException {
        ReplaceManyProxyOperation operation = ((ReplaceManyProxyOperation.Builder)((ReplaceManyProxyOperation.Builder)((ReplaceManyProxyOperation.Builder)((ReplaceManyProxyOperation.Builder)((ReplaceManyProxyOperation.Builder)((ReplaceManyProxyOperation.Builder)new ReplaceManyProxyOperation.Builder().withClient(this.client)).withSpaceName(this.spaceName)).withFunctionName(this.operationsMapping.getReplaceManyFunctionName())).withTuples(tuples).withArgumentsMapper(this.config.getMessagePackMapper())).withResultMapper(resultMapper)).withOptions(options)).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> select(Conditions conditions) throws TarantoolClientException {
        return this.select(conditions, this.tupleResultMapper(), (SelectOptions)ProxySelectOptions.create().withTimeout(this.config.getRequestTimeout()));
    }

    @Override
    public CompletableFuture<R> select(Conditions conditions, SelectOptions options) throws TarantoolClientException {
        if (options == null) {
            throw new IllegalArgumentException("Options should not be null");
        }
        return this.select(conditions, this.tupleResultMapper(), options);
    }

    private CompletableFuture<R> select(Conditions conditions, CallResultMapper<R, SingleValueCallResult<R>> resultMapper, SelectOptions options) throws TarantoolClientException {
        SelectProxyOperation operation = ((SelectProxyOperation.Builder)((SelectProxyOperation.Builder)((SelectProxyOperation.Builder)((SelectProxyOperation.Builder)((SelectProxyOperation.Builder)((SelectProxyOperation.Builder)((SelectProxyOperation.Builder)new SelectProxyOperation.Builder(this.metadataOperations, this.spaceMetadata).withClient(this.client)).withSpaceName(this.spaceName)).withFunctionName(this.operationsMapping.getSelectFunctionName())).withConditions(conditions).withOptions(options)).withArgumentsMapper(this.config.getMessagePackMapper())).withResultMapper(resultMapper)).withOptions(options)).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> update(Conditions conditions, T tuple) {
        return this.update(conditions, this.makeOperationsFromTuple(tuple), this.tupleResultMapper(), (UpdateOptions)ProxyUpdateOptions.create().withTimeout(this.config.getRequestTimeout()));
    }

    @Override
    public CompletableFuture<R> update(Conditions conditions, T tuple, UpdateOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Options should not be null");
        }
        return this.update(conditions, this.makeOperationsFromTuple(tuple), this.tupleResultMapper(), options);
    }

    protected abstract TupleOperations makeOperationsFromTuple(T var1);

    @Override
    public CompletableFuture<R> update(Conditions conditions, TupleOperations operations) {
        return this.update(conditions, operations, this.tupleResultMapper(), (UpdateOptions)ProxyUpdateOptions.create().withTimeout(this.config.getRequestTimeout()));
    }

    @Override
    public CompletableFuture<R> update(Conditions conditions, TupleOperations operations, UpdateOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Options should not be null");
        }
        return this.update(conditions, operations, this.tupleResultMapper(), options);
    }

    private CompletableFuture<R> update(Conditions conditions, TupleOperations operations, CallResultMapper<R, SingleValueCallResult<R>> resultMapper, UpdateOptions options) {
        TarantoolIndexQuery indexQuery = conditions.toIndexQuery(this.metadataOperations, this.spaceMetadata);
        UpdateProxyOperation operation = ((UpdateProxyOperation.Builder)((UpdateProxyOperation.Builder)((UpdateProxyOperation.Builder)((UpdateProxyOperation.Builder)((UpdateProxyOperation.Builder)((UpdateProxyOperation.Builder)new UpdateProxyOperation.Builder().withClient(this.client)).withSpaceName(this.spaceName)).withFunctionName(this.operationsMapping.getUpdateFunctionName())).withIndexQuery(indexQuery).withTupleOperation(operations).withArgumentsMapper(this.config.getMessagePackMapper())).withResultMapper(resultMapper)).withOptions(options)).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<R> upsert(Conditions conditions, T tuple, TupleOperations operations) {
        return this.upsert(conditions, tuple, operations, this.tupleResultMapper(), (UpsertOptions)ProxyUpsertOptions.create().withTimeout(this.config.getRequestTimeout()));
    }

    @Override
    public CompletableFuture<R> upsert(Conditions conditions, T tuple, TupleOperations operations, UpsertOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Options should not be null");
        }
        return this.upsert(conditions, tuple, operations, this.tupleResultMapper(), options);
    }

    private CompletableFuture<R> upsert(Conditions conditions, T tuple, TupleOperations operations, CallResultMapper<R, SingleValueCallResult<R>> resultMapper, UpsertOptions options) {
        UpsertProxyOperation operation = ((UpsertProxyOperation.Builder)((UpsertProxyOperation.Builder)((UpsertProxyOperation.Builder)((UpsertProxyOperation.Builder)((UpsertProxyOperation.Builder)((UpsertProxyOperation.Builder)new UpsertProxyOperation.Builder().withClient(this.client)).withSpaceName(this.spaceName)).withFunctionName(this.operationsMapping.getUpsertFunctionName())).withTuple(tuple).withTupleOperation(operations).withArgumentsMapper(this.config.getMessagePackMapper())).withResultMapper(resultMapper)).withOptions(options)).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<Void> truncate() throws TarantoolClientException {
        try {
            return this.executeVoidOperation(((TruncateProxyOperation.Builder)((TruncateProxyOperation.Builder)((TruncateProxyOperation.Builder)((TruncateProxyOperation.Builder)TruncateProxyOperation.builder().withClient(this.client)).withSpaceName(this.spaceName)).withFunctionName(this.operationsMapping.getTruncateFunctionName())).withOptions(ProxyTruncateOptions.create().withTimeout(this.config.getRequestTimeout()))).build());
        }
        catch (TarantoolClientException e) {
            throw new TarantoolClientException(e);
        }
    }

    protected abstract CallResultMapper<R, SingleValueCallResult<R>> tupleResultMapper();

    private CompletableFuture<R> executeOperation(ProxyOperation<R> operation) {
        return operation.execute();
    }

    private CompletableFuture<Void> executeVoidOperation(ProxyOperation<Void> operation) {
        return operation.execute();
    }

    @Override
    public TarantoolSpaceMetadata getMetadata() {
        return this.spaceMetadata;
    }

    public String toString() {
        return String.format("ProxyTarantoolSpace [%s]", this.spaceName);
    }
}

