/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.AbstractResultMapper;
import io.tarantool.driver.mappers.InterfaceParameterClassNotFoundException;
import io.tarantool.driver.mappers.MapperReflectionUtils;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.converters.ValueConverter;
import org.msgpack.value.ArrayValue;

public abstract class AbstractResultMapperFactory<O, T extends AbstractResultMapper<? extends O>> {
    protected abstract T createMapper(MessagePackValueMapper var1, ValueConverter<ArrayValue, ? extends O> var2, Class<? extends O> var3);

    public T withConverter(MessagePackValueMapper valueMapper, ValueConverter<ArrayValue, ? extends O> valueConverter) {
        try {
            return this.withConverter(valueMapper, valueConverter, MapperReflectionUtils.getConverterTargetType(valueConverter));
        }
        catch (InterfaceParameterClassNotFoundException e) {
            throw new TarantoolClientException(e);
        }
    }

    public T withConverter(MessagePackValueMapper valueMapper, ValueConverter<ArrayValue, ? extends O> valueConverter, Class<? extends O> resultClass) {
        return this.createMapper(valueMapper, valueConverter, resultClass);
    }
}

