/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol;

import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.value.ImmutableIntegerValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public final class TarantoolHeader
implements Packable {
    private static final int IPROTO_REQUEST_TYPE = 0;
    private static final int IPROTO_SYNC = 1;
    private static final int IPROTO_REPLICA_ID = 2;
    private static final int IPROTO_LSN = 3;
    private static final int IPROTO_TIMESTAMP = 4;
    private static final int IPROTO_SCHEMA_VERSION = 5;
    private Long sync;
    private Long code;
    private Long schemaVersion;
    private Long replicaId;
    private Long lsn;
    private Double timestamp;

    private TarantoolHeader() {
    }

    TarantoolHeader(Long sync, Long code) {
        this.sync = sync;
        this.code = code;
    }

    TarantoolHeader(Long sync, Long code, Long schemaVersion) {
        this.sync = sync;
        this.code = code;
        this.schemaVersion = schemaVersion;
    }

    public void setSync(Long sync) {
        this.sync = sync;
    }

    public Long getSync() {
        return this.sync;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public Long getCode() {
        return this.code;
    }

    public void setSchemaVersion(Long schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public Long getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setReplicaId(Long replicaId) {
        this.replicaId = replicaId;
    }

    public Long getReplicaId() {
        return this.replicaId;
    }

    public Long getLsn() {
        return this.lsn;
    }

    public void setLsn(Long lsn) {
        this.lsn = lsn;
    }

    public Double getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Double timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public Value toMessagePackValue(MessagePackObjectMapper mapper) {
        HashMap<ImmutableIntegerValue, ImmutableIntegerValue> values = new HashMap<ImmutableIntegerValue, ImmutableIntegerValue>();
        values.put(ValueFactory.newInteger((int)0), ValueFactory.newInteger((long)this.code));
        values.put(ValueFactory.newInteger((int)1), ValueFactory.newInteger((long)this.sync));
        if (this.schemaVersion != null) {
            values.put(ValueFactory.newInteger((int)5), ValueFactory.newInteger((long)this.schemaVersion));
        }
        return ValueFactory.newMap(values);
    }

    public static TarantoolHeader fromMessagePackValue(Value value) throws TarantoolProtocolException {
        if (!value.isMapValue()) {
            throw new TarantoolProtocolException("TarantoolHeader can be unpacked only from MP_MAP, received " + value.toString());
        }
        Map values = value.asMapValue().map();
        TarantoolHeader header = new TarantoolHeader();
        for (Value key : values.keySet()) {
            if (!key.isIntegerValue()) {
                throw new TarantoolProtocolException("TarantoolHeader keys must be of MP_INT type");
            }
            Value field = (Value)values.get(key);
            if (!field.isNumberValue()) {
                throw new TarantoolProtocolException("TarantoolHeader values must be of MP_INT type");
            }
            switch (key.asIntegerValue().asInt()) {
                case 0: {
                    header.setCode(field.asIntegerValue().asLong());
                    break;
                }
                case 1: {
                    header.setSync(field.asIntegerValue().asLong());
                    break;
                }
                case 5: {
                    header.setSchemaVersion(field.asIntegerValue().asLong());
                    break;
                }
                case 3: {
                    header.setLsn(field.asIntegerValue().asLong());
                    break;
                }
                case 2: {
                    header.setReplicaId(field.asIntegerValue().asLong());
                    break;
                }
                case 4: {
                    header.setTimestamp(field.asFloatValue().toDouble());
                }
            }
        }
        if (header.getCode() == null) {
            throw new TarantoolProtocolException("No request or response code found");
        }
        if (header.getSync() == null) {
            throw new TarantoolProtocolException("No sync ID found");
        }
        return header;
    }
}

