/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver;

import io.tarantool.driver.AbstractTarantoolClient;
import io.tarantool.driver.ConnectionSelectionStrategyFactory;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolClusterAddressProvider;
import io.tarantool.driver.TarantoolServerAddress;
import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.auth.TarantoolCredentials;
import io.tarantool.driver.core.TarantoolClusterConnectionManager;
import io.tarantool.driver.core.TarantoolConnectionFactory;
import io.tarantool.driver.core.TarantoolConnectionListeners;
import io.tarantool.driver.core.TarantoolConnectionManager;
import io.tarantool.driver.core.TarantoolConnectionSelectionStrategies;
import java.util.Collection;
import java.util.Collections;

public class ClusterTarantoolClient
extends AbstractTarantoolClient {
    private final ConnectionSelectionStrategyFactory selectStrategyFactory;
    private TarantoolClusterAddressProvider addressProvider;

    public ClusterTarantoolClient() {
        this(new SimpleTarantoolCredentials());
    }

    public ClusterTarantoolClient(TarantoolCredentials credentials) {
        this(credentials, Collections.singletonList(new TarantoolServerAddress()));
    }

    public ClusterTarantoolClient(TarantoolCredentials credentials, String host, int port) {
        this(credentials, Collections.singletonList(new TarantoolServerAddress(host, port)));
    }

    public ClusterTarantoolClient(TarantoolCredentials credentials, Collection<TarantoolServerAddress> addresses) {
        this(TarantoolClientConfig.builder().withCredentials(credentials).build(), () -> addresses, TarantoolConnectionSelectionStrategies.ParallelRoundRobinStrategyFactory.INSTANCE);
    }

    public ClusterTarantoolClient(TarantoolClientConfig config, TarantoolClusterAddressProvider addressProvider, ConnectionSelectionStrategyFactory selectStrategyFactory) {
        super(config);
        this.addressProvider = addressProvider;
        this.selectStrategyFactory = selectStrategyFactory;
    }

    @Override
    protected TarantoolConnectionManager connectionManager(TarantoolClientConfig config, TarantoolConnectionFactory connectionFactory, TarantoolConnectionListeners listeners) {
        return new TarantoolClusterConnectionManager(config, connectionFactory, this.selectStrategyFactory, listeners, this.addressProvider);
    }
}

