/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver;

import io.tarantool.driver.TarantoolClusterAddressProvider;
import io.tarantool.driver.TarantoolServerAddress;
import io.tarantool.driver.cluster.BinaryClusterDiscoveryEndpoint;
import io.tarantool.driver.cluster.BinaryDiscoveryClusterAddressProvider;
import io.tarantool.driver.cluster.HTTPDiscoveryClusterAddressProvider;
import io.tarantool.driver.cluster.TarantoolClusterDiscoveryConfig;
import java.util.Collection;
import org.springframework.util.Assert;

public final class TarantoolAddressProviderFactory {
    private TarantoolAddressProviderFactory() {
    }

    public TarantoolClusterAddressProvider createClusterAddressProvider(Collection<TarantoolServerAddress> nodes) {
        Assert.notNull(nodes, (String)"Collection of Tarantool server address should not be null");
        Assert.notEmpty(nodes, (String)"Collection of Tarantool server address should not be empty");
        return () -> nodes;
    }

    public TarantoolClusterAddressProvider createClusterAddressProviderWithDiscovery(Collection<TarantoolServerAddress> nodes, TarantoolClusterDiscoveryConfig config) {
        TarantoolClusterAddressProvider addressProvider = config != null ? (config.getEndpoint() instanceof BinaryClusterDiscoveryEndpoint ? new BinaryDiscoveryClusterAddressProvider(config) : new HTTPDiscoveryClusterAddressProvider(config)) : this.createClusterAddressProvider(nodes);
        return addressProvider;
    }
}

