/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver;

import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.auth.TarantoolCredentials;
import io.tarantool.driver.mappers.DefaultMessagePackMapperFactory;
import io.tarantool.driver.mappers.MessagePackMapper;
import org.springframework.util.Assert;

public class TarantoolClientConfig {
    private static final int DEFAULT_CONNECT_TIMEOUT = 1000;
    private static final int DEFAULT_READ_TIMEOUT = 1000;
    private static final int DEFAULT_REQUEST_TIMEOUT = 2000;
    private static final int DEFAULT_CONNECTIONS = 1;
    private TarantoolCredentials credentials;
    private int connectTimeout = 1000;
    private int readTimeout = 1000;
    private int requestTimeout = 2000;
    private int connections = 1;
    private MessagePackMapper messagePackMapper = DefaultMessagePackMapperFactory.getInstance().defaultComplexTypesMapper();

    public TarantoolCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(TarantoolCredentials credentials) {
        this.credentials = credentials;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnections() {
        return this.connections;
    }

    public void setConnections(int connections) {
        this.connections = connections;
    }

    public MessagePackMapper getMessagePackMapper() {
        return this.messagePackMapper;
    }

    public void setMessagePackMapper(MessagePackMapper messagePackMapper) {
        this.messagePackMapper = messagePackMapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TarantoolClientConfig config = new TarantoolClientConfig();

        public Builder withCredentials(TarantoolCredentials credentials) {
            Assert.notNull((Object)credentials, (String)"Tarantool server credentials should not be null");
            this.config.setCredentials(credentials);
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            Assert.state((readTimeout > 0 ? 1 : 0) != 0, (String)"Response reading timeout should be greater than 0");
            this.config.setReadTimeout(readTimeout);
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            Assert.state((connectTimeout > 0 ? 1 : 0) != 0, (String)"Connection timeout should be greater than 0");
            this.config.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder withRequestTimeout(int requestTimeout) {
            Assert.state((requestTimeout > 0 ? 1 : 0) != 0, (String)"Request timeout should be greater than 0");
            this.config.setRequestTimeout(requestTimeout);
            return this;
        }

        public Builder withMessagePackMapper(MessagePackMapper mapper) {
            Assert.notNull((Object)mapper, (String)"MessagePack mapper should not be null");
            this.config.setMessagePackMapper(mapper);
            return this;
        }

        public Builder withConnections(int connections) {
            Assert.state((connections > 1 ? 1 : 0) != 0, (String)"The number of server connections must be greater than 0");
            this.config.connections = connections;
            return this;
        }

        public TarantoolClientConfig build() {
            if (this.config.getCredentials() == null) {
                this.config.setCredentials(new SimpleTarantoolCredentials());
            }
            return this.config;
        }

        public Builder clear() {
            this.config = new TarantoolClientConfig();
            return this;
        }
    }
}

