/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver;

import io.tarantool.driver.exceptions.TarantoolSocketException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class TarantoolServerAddress
implements Serializable {
    private static final long serialVersionUID = 7327851568010264254L;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 3301;
    private final String host;
    private final int port;

    public TarantoolServerAddress() {
        this(DEFAULT_HOST, 3301);
    }

    public TarantoolServerAddress(String host) {
        this(host, 3301);
    }

    public TarantoolServerAddress(String host, int port) {
        String[] parts = host.split("@");
        String[] addressParts = parts[parts.length - 1].split(":");
        if (addressParts.length > 2) {
            throw new IllegalArgumentException(String.format("Invalid host name: %s", host));
        }
        int portNumber = port;
        if (addressParts.length == 2) {
            try {
                portNumber = Integer.parseInt(addressParts[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Invalid host name: %s", host));
            }
        }
        if (portNumber <= 0 || portNumber > 65535) {
            throw new IllegalArgumentException(String.format("Invalid port number : %s", portNumber));
        }
        this.host = addressParts[0];
        this.port = portNumber;
    }

    public TarantoolServerAddress(InetSocketAddress socketAddress) {
        this.host = socketAddress.getHostName();
        this.port = socketAddress.getPort();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getSocketAddress() throws TarantoolSocketException {
        try {
            return new InetSocketAddress(InetAddress.getByName(this.host), this.port);
        }
        catch (UnknownHostException e) {
            throw new TarantoolSocketException(e.getMessage(), this, e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TarantoolServerAddress that = (TarantoolServerAddress)o;
        if (this.port != that.port) {
            return false;
        }
        return this.host.equals(that.host);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

