/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api;

import io.tarantool.driver.api.TarantoolIndexQuery;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolIndexNotFoundException;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import java.util.Optional;

public class TarantoolIndexQueryFactory {
    private final TarantoolMetadataOperations metadataOperations;

    public TarantoolIndexQueryFactory(TarantoolMetadataOperations metadataOperations) {
        this.metadataOperations = metadataOperations;
    }

    public TarantoolIndexQuery primary() {
        return new TarantoolIndexQuery();
    }

    public TarantoolIndexQuery byName(int spaceId, String indexName) throws TarantoolClientException {
        Optional<TarantoolIndexMetadata> meta = this.metadataOperations.getIndexByName(spaceId, indexName);
        if (!meta.isPresent()) {
            throw new TarantoolIndexNotFoundException(spaceId, indexName);
        }
        return new TarantoolIndexQuery(meta.get().getIndexId());
    }

    public TarantoolIndexQuery byId(String spaceName, String indexName) throws TarantoolClientException {
        Optional<TarantoolIndexMetadata> meta = this.metadataOperations.getIndexByName(spaceName, indexName);
        if (!meta.isPresent()) {
            throw new TarantoolIndexNotFoundException(spaceName, indexName);
        }
        return new TarantoolIndexQuery(meta.get().getIndexId());
    }
}

