/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.space;

import io.tarantool.driver.ProxyTarantoolClient;
import io.tarantool.driver.api.TarantoolIndexQuery;
import io.tarantool.driver.api.TarantoolIndexQueryFactory;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.TarantoolSelectOptions;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.TarantoolCallResultMapper;
import io.tarantool.driver.mappers.TarantoolCallResultMapperFactory;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.protocol.TarantoolIteratorType;
import io.tarantool.driver.protocol.operations.TupleOperations;
import io.tarantool.driver.proxy.DeleteProxyOperation;
import io.tarantool.driver.proxy.InsertProxyOperation;
import io.tarantool.driver.proxy.ProxyOperation;
import io.tarantool.driver.proxy.ProxySelectArgumentsConverter;
import io.tarantool.driver.proxy.ReplaceProxyOperation;
import io.tarantool.driver.proxy.SelectProxyOperation;
import io.tarantool.driver.proxy.UpdateProxyOperation;
import io.tarantool.driver.proxy.UpsertProxyOperation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.msgpack.value.ArrayValue;

public class ProxyTarantoolSpace
implements TarantoolSpaceOperations {
    private final String spaceName;
    private final ProxyTarantoolClient client;
    private final TarantoolMetadataOperations metadataOperations;
    private final TarantoolSpaceMetadata spaceMetadata;
    private final TarantoolIndexQueryFactory indexQueryFactory;
    private final TarantoolCallResultMapperFactory tarantoolResultMapperFactory;

    public ProxyTarantoolSpace(ProxyTarantoolClient client, TarantoolSpaceMetadata spaceMetadata) {
        this.client = client;
        this.spaceMetadata = spaceMetadata;
        this.spaceName = spaceMetadata.getSpaceName();
        this.indexQueryFactory = new TarantoolIndexQueryFactory(client.metadata());
        this.metadataOperations = client.metadata();
        this.tarantoolResultMapperFactory = new TarantoolCallResultMapperFactory(client.getConfig().getMessagePackMapper());
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> delete(TarantoolIndexQuery indexQuery) throws TarantoolClientException {
        return this.delete(indexQuery, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> delete(TarantoolIndexQuery indexQuery, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.delete(indexQuery, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> delete(TarantoolIndexQuery indexQuery, TarantoolCallResultMapper<T> resultMapper) throws TarantoolClientException {
        DeleteProxyOperation operation = new DeleteProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getDeleteFunctionName()).withIndexQuery(indexQuery).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> insert(TarantoolTuple tuple) throws TarantoolClientException {
        return this.insert(tuple, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> insert(TarantoolTuple tuple, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.insert(tuple, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> insert(TarantoolTuple tuple, TarantoolCallResultMapper<T> resultMapper) throws TarantoolClientException {
        InsertProxyOperation operation = new InsertProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getInsertFunctionName()).withTuple(tuple).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> replace(TarantoolTuple tuple) throws TarantoolClientException {
        return this.replace(tuple, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> replace(TarantoolTuple tuple, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.replace(tuple, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> replace(TarantoolTuple tuple, TarantoolCallResultMapper<T> resultMapper) throws TarantoolClientException {
        ReplaceProxyOperation operation = new ReplaceProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getReplaceFunctionName()).withTuple(tuple).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> select(TarantoolSelectOptions options) throws TarantoolClientException {
        return this.select(this.indexQueryFactory.primary(), options);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> select(String indexName, TarantoolSelectOptions options) throws TarantoolClientException {
        TarantoolIndexQuery indexQuery = this.indexQueryFactory.byId(indexName, this.spaceName);
        return this.select(indexQuery, options);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> select(String indexName, TarantoolIteratorType iteratorType, TarantoolSelectOptions options) throws TarantoolClientException {
        TarantoolIndexQuery indexQuery = this.indexQueryFactory.byId(indexName, this.spaceName).withIteratorType(iteratorType);
        return this.select(indexQuery, options);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> select(TarantoolIndexQuery indexQuery, TarantoolSelectOptions options) throws TarantoolClientException {
        return this.select(indexQuery, options, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> select(TarantoolIndexQuery indexQuery, TarantoolSelectOptions options, Class<T> tupleClass) throws TarantoolClientException {
        ValueConverter<ArrayValue, T> converter = this.getConverter(tupleClass);
        return this.select(indexQuery, options, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((Class)tupleClass, (ValueConverter)converter));
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> select(TarantoolIndexQuery indexQuery, TarantoolSelectOptions options, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.select(indexQuery, options, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> select(TarantoolIndexQuery indexQuery, TarantoolSelectOptions options, TarantoolCallResultMapper<T> resultMapper) throws TarantoolClientException {
        List<?> selectArguments = Collections.EMPTY_LIST;
        if (!indexQuery.getKeyValues().isEmpty()) {
            Optional<TarantoolIndexMetadata> indexMetadata = this.metadataOperations.getIndexById(this.spaceName, indexQuery.getIndexId());
            if (!indexMetadata.isPresent()) {
                throw new TarantoolClientException("Index metadata not found for index id: {}", indexQuery.getIndexId());
            }
            selectArguments = ProxySelectArgumentsConverter.fromIndexQuery(indexQuery, indexMetadata.get().getIndexParts(), this.spaceMetadata);
        }
        SelectProxyOperation operation = new SelectProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getSelectFunctionName()).withSelectArguments(selectArguments).withSelectOptions(options).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> update(TarantoolIndexQuery indexQuery, TupleOperations operations) {
        return this.update(indexQuery, operations, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> update(TarantoolIndexQuery indexQuery, TupleOperations operations, ValueConverter<ArrayValue, T> tupleMapper) {
        return this.update(indexQuery, operations, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> update(TarantoolIndexQuery indexQuery, TupleOperations operations, TarantoolCallResultMapper<T> resultMapper) {
        UpdateProxyOperation operation = new UpdateProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getUpdateFunctionName()).withIndexQuery(indexQuery).withTupleOperation(operations).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> upsert(TarantoolIndexQuery indexQuery, TarantoolTuple tuple, TupleOperations operations) {
        return this.upsert(indexQuery, tuple, operations, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> upsert(TarantoolIndexQuery indexQuery, TarantoolTuple tuple, TupleOperations operations, ValueConverter<ArrayValue, T> tupleMapper) {
        return this.upsert(indexQuery, tuple, operations, (TarantoolCallResultMapper<T>)this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> upsert(TarantoolIndexQuery indexQuery, TarantoolTuple tuple, TupleOperations operations, TarantoolCallResultMapper<T> resultMapper) {
        UpsertProxyOperation operation = new UpsertProxyOperation.Builder().withClient(this.client).withSpaceName(this.spaceName).withFunctionName(this.client.getUpsertFunctionName()).withTuple(tuple).withTupleOperation(operations).withResultMapper(resultMapper).build();
        return this.executeOperation(operation);
    }

    private TarantoolCallResultMapper<TarantoolTuple> defaultTupleResultMapper() {
        return this.tarantoolResultMapperFactory.withDefaultTupleValueConverter(this.spaceMetadata);
    }

    private <T> ValueConverter<ArrayValue, T> getConverter(Class<T> tupleClass) {
        Optional<ValueConverter<ArrayValue, T>> converter = this.client.getConfig().getMessagePackMapper().getValueConverter(ArrayValue.class, tupleClass);
        if (!converter.isPresent()) {
            throw new TarantoolClientException("No ArrayValue converter for type " + tupleClass + " is present");
        }
        return converter.get();
    }

    private <T> CompletableFuture<TarantoolResult<T>> executeOperation(ProxyOperation<T> operation) {
        return operation.execute();
    }

    public String toString() {
        return String.format("ProxyTarantoolSpace [%s]", this.spaceName);
    }
}

