/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api.space;

import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolIndexQuery;
import io.tarantool.driver.api.TarantoolIndexQueryFactory;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.TarantoolSelectOptions;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.core.TarantoolConnectionManager;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolSpaceOperationException;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.TarantoolSimpleResultMapperFactory;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.protocol.TarantoolIteratorType;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequest;
import io.tarantool.driver.protocol.operations.TupleOperations;
import io.tarantool.driver.protocol.requests.TarantoolDeleteRequest;
import io.tarantool.driver.protocol.requests.TarantoolInsertRequest;
import io.tarantool.driver.protocol.requests.TarantoolReplaceRequest;
import io.tarantool.driver.protocol.requests.TarantoolSelectRequest;
import io.tarantool.driver.protocol.requests.TarantoolUpdateRequest;
import io.tarantool.driver.protocol.requests.TarantoolUpsertRequest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.msgpack.value.ArrayValue;

public class TarantoolSpace
implements TarantoolSpaceOperations {
    private final int spaceId;
    private final TarantoolClientConfig config;
    private final TarantoolConnectionManager connectionManager;
    private final TarantoolSpaceMetadata spaceMetadata;
    private final TarantoolIndexQueryFactory indexQueryFactory;
    private final TarantoolMetadataOperations metadataOperations;
    private final TarantoolSimpleResultMapperFactory tarantoolResultMapperFactory;

    public TarantoolSpace(TarantoolClientConfig config, TarantoolConnectionManager connectionManager, TarantoolSpaceMetadata spaceMetadata, TarantoolMetadataOperations metadataOperations) {
        this.spaceId = spaceMetadata.getSpaceId();
        this.config = config;
        this.connectionManager = connectionManager;
        this.spaceMetadata = spaceMetadata;
        this.indexQueryFactory = new TarantoolIndexQueryFactory(metadataOperations);
        this.metadataOperations = metadataOperations;
        this.tarantoolResultMapperFactory = new TarantoolSimpleResultMapperFactory(config.getMessagePackMapper());
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> delete(TarantoolIndexQuery indexQuery) throws TarantoolClientException {
        return this.delete(indexQuery, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> delete(TarantoolIndexQuery indexQuery, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.delete(indexQuery, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> delete(TarantoolIndexQuery indexQuery, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolDeleteRequest request = new TarantoolDeleteRequest.Builder().withSpaceId(this.spaceId).withIndexId(indexQuery.getIndexId()).withKeyValues(indexQuery.getKeyValues()).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> insert(TarantoolTuple tuple) throws TarantoolClientException {
        return this.insert(tuple, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> insert(TarantoolTuple tuple, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.replace(tuple, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> insert(TarantoolTuple tuple, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolInsertRequest request = new TarantoolInsertRequest.Builder().withSpaceId(this.spaceId).withTuple(tuple).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> replace(TarantoolTuple tuple) throws TarantoolClientException {
        return this.replace(tuple, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> replace(TarantoolTuple tuple, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.replace(tuple, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> replace(TarantoolTuple tuple, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolReplaceRequest request = new TarantoolReplaceRequest.Builder().withSpaceId(this.spaceId).withTuple(tuple).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> select(TarantoolSelectOptions options) throws TarantoolClientException {
        return this.select(this.indexQueryFactory.primary(), options);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> select(String indexName, TarantoolSelectOptions options) throws TarantoolClientException {
        TarantoolIndexQuery indexQuery = this.indexQueryFactory.byName(this.spaceId, indexName);
        return this.select(indexQuery, options);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> select(String indexName, TarantoolIteratorType iteratorType, TarantoolSelectOptions options) throws TarantoolClientException {
        TarantoolIndexQuery indexQuery = this.indexQueryFactory.byName(this.spaceId, indexName).withIteratorType(iteratorType);
        return this.select(indexQuery, options);
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> select(TarantoolIndexQuery indexQuery, TarantoolSelectOptions options) throws TarantoolClientException {
        return this.select(indexQuery, options, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> select(TarantoolIndexQuery indexQuery, TarantoolSelectOptions options, Class<T> tupleClass) throws TarantoolClientException {
        ValueConverter<ArrayValue, T> converter = this.getConverter(tupleClass);
        return this.select(indexQuery, options, this.tarantoolResultMapperFactory.withConverter((Class)tupleClass, (ValueConverter)converter));
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> select(TarantoolIndexQuery indexQuery, TarantoolSelectOptions options, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.select(indexQuery, options, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> select(TarantoolIndexQuery indexQuery, TarantoolSelectOptions options, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolSelectRequest request = new TarantoolSelectRequest.Builder().withSpaceId(this.spaceId).withIndexId(indexQuery.getIndexId()).withIteratorType(indexQuery.getIteratorType()).withKeyValues(indexQuery.getKeyValues()).withLimit(options.getLimit()).withOffset(options.getOffset()).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> update(TarantoolIndexQuery indexQuery, TupleOperations operations) {
        return this.update(indexQuery, operations, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> update(TarantoolIndexQuery indexQuery, TupleOperations operations, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.update(indexQuery, operations, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> update(TarantoolIndexQuery indexQuery, TupleOperations operations, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            Optional<TarantoolIndexMetadata> indexMetadata = this.metadataOperations.getIndexById(this.spaceId, indexQuery.getIndexId());
            if (!indexMetadata.isPresent() || !indexMetadata.get().isUnique()) {
                throw new TarantoolSpaceOperationException("Index must be primary or unique for update operation");
            }
            TarantoolUpdateRequest request = new TarantoolUpdateRequest.Builder(this.spaceMetadata).withSpaceId(this.spaceId).withIndexId(indexQuery.getIndexId()).withKeyValues(indexQuery.getKeyValues()).withTupleOperations(operations).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<TarantoolResult<TarantoolTuple>> upsert(TarantoolIndexQuery indexQuery, TarantoolTuple tuple, TupleOperations operations) {
        TarantoolSpaceMetadata meta = this.metadataOperations.getSpaceById(this.spaceId).orElse(null);
        return this.upsert(indexQuery, tuple, operations, this.defaultTupleResultMapper());
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> upsert(TarantoolIndexQuery indexQuery, TarantoolTuple tuple, TupleOperations operations, ValueConverter<ArrayValue, T> tupleMapper) throws TarantoolClientException {
        return this.upsert(indexQuery, tuple, operations, this.tarantoolResultMapperFactory.withConverter((ValueConverter)tupleMapper));
    }

    private <T> CompletableFuture<TarantoolResult<T>> upsert(TarantoolIndexQuery indexQuery, TarantoolTuple tuple, TupleOperations operations, MessagePackValueMapper resultMapper) throws TarantoolClientException {
        try {
            TarantoolUpsertRequest request = new TarantoolUpsertRequest.Builder(this.spaceMetadata).withSpaceId(this.spaceId).withKeyValues(indexQuery.getKeyValues()).withTuple(tuple).withTupleOperations(operations).build(this.config.getMessagePackMapper());
            return this.sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    private <T> ValueConverter<ArrayValue, T> getConverter(Class<T> tupleClass) {
        Optional<ValueConverter<ArrayValue, T>> converter = this.config.getMessagePackMapper().getValueConverter(ArrayValue.class, tupleClass);
        if (!converter.isPresent()) {
            throw new TarantoolClientException("No ArrayValue converter for type " + tupleClass + " is present");
        }
        return converter.get();
    }

    private MessagePackValueMapper defaultTupleResultMapper() {
        return this.tarantoolResultMapperFactory.withDefaultTupleValueConverter(this.spaceMetadata);
    }

    private <T> CompletableFuture<TarantoolResult<T>> sendRequest(TarantoolRequest request, MessagePackValueMapper resultMapper) {
        try {
            return this.connectionManager.getConnection().sendRequest(request, resultMapper);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    public String toString() {
        return String.format("TarantoolSpace %s [%d]", this.spaceMetadata.getSpaceName(), this.spaceMetadata.getSpaceId());
    }
}

