/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.auth;

import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.auth.TarantoolAuthMechanism;
import io.tarantool.driver.auth.TarantoolAuthenticationException;
import io.tarantool.driver.auth.TarantoolAuthenticator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ChapSha1TarantoolAuthenticator
implements TarantoolAuthenticator<SimpleTarantoolCredentials> {
    @Override
    public TarantoolAuthMechanism getMechanism() {
        return TarantoolAuthMechanism.CHAPSHA1;
    }

    @Override
    public boolean canAuthenticateWith(SimpleTarantoolCredentials credentials) {
        return StringUtils.hasText((String)credentials.getUsername()) && StringUtils.hasText((String)credentials.getPassword());
    }

    @Override
    public byte[] prepareUserAuthData(byte[] serverAuthData, SimpleTarantoolCredentials credentials) throws TarantoolAuthenticationException {
        Assert.notNull((Object)serverAuthData, (String)"Server response must not be null");
        Assert.notNull((Object)credentials, (String)"Credentials must not be null");
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] auth = sha1.digest(credentials.getPassword().getBytes());
            byte[] auth2 = sha1.digest(auth);
            byte[] salt = Base64.getDecoder().decode(serverAuthData);
            sha1.update(salt, 0, 20);
            sha1.update(auth2);
            byte[] scramble = sha1.digest();
            for (int i = 0; i < 20; ++i) {
                int n = i;
                auth[n] = (byte)(auth[n] ^ scramble[i]);
            }
            return auth;
        }
        catch (NoSuchAlgorithmException e) {
            throw new TarantoolAuthenticationException(e);
        }
    }
}

