/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.cluster;

import io.tarantool.driver.TarantoolServerAddress;
import io.tarantool.driver.auth.TarantoolCredentials;
import io.tarantool.driver.cluster.TarantoolClusterDiscoveryEndpoint;
import org.springframework.util.Assert;

public class BinaryClusterDiscoveryEndpoint
implements TarantoolClusterDiscoveryEndpoint {
    private TarantoolServerAddress serverAddress;
    private TarantoolCredentials credentials;
    private String discoveryFunction;

    public TarantoolServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(TarantoolServerAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    public TarantoolCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(TarantoolCredentials credentials) {
        this.credentials = credentials;
    }

    public String getDiscoveryFunction() {
        return this.discoveryFunction;
    }

    public void setDiscoveryFunction(String discoveryFunction) {
        this.discoveryFunction = discoveryFunction;
    }

    public static class Builder {
        private BinaryClusterDiscoveryEndpoint endpoint = new BinaryClusterDiscoveryEndpoint();

        public Builder withEntryFunction(String discoveryFunction) {
            Assert.hasText((String)discoveryFunction, (String)"The discovery function name should not be null or empty");
            this.endpoint.setDiscoveryFunction(discoveryFunction);
            return this;
        }

        public Builder withServerAddress(TarantoolServerAddress serverAddress) {
            Assert.notNull((Object)serverAddress, (String)"Discovery endpoint address should not be null");
            this.endpoint.setServerAddress(serverAddress);
            return this;
        }

        public Builder withCredentials(TarantoolCredentials credentials) {
            this.endpoint.setCredentials(credentials);
            return this;
        }

        public BinaryClusterDiscoveryEndpoint build() {
            return this.endpoint;
        }
    }
}

