/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.codecs;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.tarantool.driver.protocol.TarantoolResponse;
import java.io.InputStream;
import java.util.List;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;

public class MessagePackFrameDecoder
extends ReplayingDecoder<DecoderState> {
    private static final int MINIMAL_HEADER_SIZE = 5;
    private int size;

    public MessagePackFrameDecoder() {
        super((Object)DecoderState.LENGTH);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        switch ((DecoderState)((Object)this.state())) {
            case LENGTH: {
                MessageUnpacker unpacker;
                try (ByteBufInputStream in = new ByteBufInputStream(byteBuf.readBytes(5));){
                    unpacker = MessagePack.newDefaultUnpacker((InputStream)in);
                    this.size = unpacker.unpackInt();
                    this.checkpoint((Object)DecoderState.BODY);
                }
            }
            case BODY: {
                MessageUnpacker unpacker;
                Throwable throwable;
                ByteBufInputStream in;
                if (this.size > 0) {
                    in = new ByteBufInputStream(byteBuf.readBytes(this.size));
                    throwable = null;
                    try {
                        unpacker = MessagePack.newDefaultUnpacker((InputStream)in);
                        list.add(TarantoolResponse.fromMessagePack(unpacker));
                        this.size = 0;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                }
                this.checkpoint((Object)DecoderState.LENGTH);
            }
        }
    }

    protected static enum DecoderState {
        LENGTH,
        BODY;

    }
}

