/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.ConnectionSelectionStrategy;
import io.tarantool.driver.ConnectionSelectionStrategyFactory;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolServerAddress;
import io.tarantool.driver.core.TarantoolConnection;
import io.tarantool.driver.core.TarantoolConnectionFactory;
import io.tarantool.driver.core.TarantoolConnectionListener;
import io.tarantool.driver.core.TarantoolConnectionListeners;
import io.tarantool.driver.core.TarantoolConnectionManager;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolClientNotConnectedException;
import io.tarantool.driver.exceptions.TarantoolException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTarantoolConnectionManager
implements TarantoolConnectionManager {
    private final TarantoolClientConfig config;
    private final TarantoolConnectionFactory connectionFactory;
    private final ConnectionSelectionStrategyFactory selectStrategyFactory;
    private final TarantoolConnectionListeners connectionListeners;
    private final AtomicReference<Map<TarantoolServerAddress, List<TarantoolConnection>>> connectionRegistry = new AtomicReference(new HashMap());
    private final AtomicReference<ConnectionSelectionStrategy> connectionSelectStrategy = new AtomicReference();
    private final AtomicBoolean connectionMode = new AtomicBoolean(true);
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public AbstractTarantoolConnectionManager(TarantoolClientConfig config, TarantoolConnectionFactory connectionFactory, ConnectionSelectionStrategyFactory selectStrategyFactory, TarantoolConnectionListeners connectionListeners) {
        this.config = config;
        this.connectionFactory = connectionFactory;
        this.selectStrategyFactory = selectStrategyFactory;
        this.connectionListeners = connectionListeners;
    }

    protected abstract Collection<TarantoolServerAddress> getAddresses();

    @Override
    public TarantoolConnection getConnection() {
        try {
            TarantoolConnection connection = this.getConnectionInternal().get(this.config.getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (!connection.isConnected()) {
                throw new TarantoolClientNotConnectedException();
            }
            return connection;
        }
        catch (InterruptedException | TimeoutException e) {
            throw new TarantoolClientException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TarantoolException) {
                throw (TarantoolException)e.getCause();
            }
            throw new TarantoolClientException(e);
        }
    }

    private CompletableFuture<TarantoolConnection> getConnectionInternal() {
        CompletionStage<TarantoolConnection> result;
        if (this.connectionMode.compareAndSet(true, false)) {
            result = ((CompletableFuture)((CompletableFuture)this.establishConnections().thenAccept(registry -> {
                this.connectionRegistry.set((Map<TarantoolServerAddress, List<TarantoolConnection>>)registry);
                ConnectionSelectionStrategy strategy = this.selectStrategyFactory.create(this.config, registry.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
                this.connectionSelectStrategy.set(strategy);
            })).thenApply(v -> this.connectionSelectStrategy.get().next())).whenComplete((v, ex) -> {
                if (this.initLatch.getCount() > 0L) {
                    this.initLatch.countDown();
                }
            });
            for (TarantoolConnectionListener connectionListener : this.connectionListeners.all()) {
                result = result.thenCompose(connectionListener::onConnection);
            }
        } else {
            try {
                this.initLatch.await();
            }
            catch (InterruptedException e) {
                throw new TarantoolClientException("Interrupted while waiting for connection manager initialization");
            }
            result = CompletableFuture.completedFuture(this.connectionSelectStrategy.get().next());
        }
        return result;
    }

    private CompletableFuture<Map<TarantoolServerAddress, List<TarantoolConnection>>> establishConnections() throws TarantoolClientException {
        List<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>> endpointConnections = this.getConnections();
        return CompletableFuture.allOf(endpointConnections.toArray(new CompletableFuture[0])).thenApply(v -> endpointConnections.parallelStream().map(CompletableFuture::join).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private List<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>> getConnections() {
        Collection<TarantoolServerAddress> addresses = this.getAddresses();
        ArrayList<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>> endpointConnections = new ArrayList<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>>(addresses.size());
        for (TarantoolServerAddress serverAddress : addresses) {
            List<TarantoolConnection> aliveConnections = this.getAliveConnections(serverAddress);
            if (aliveConnections.size() != this.config.getConnections()) {
                for (TarantoolConnection aliveConnection : aliveConnections) {
                    try {
                        aliveConnection.close();
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to close the connection", (Throwable)e);
                    }
                }
                CompletionStage connectionFuture = this.establishConnectionsToEndpoint(serverAddress).thenApply(connections -> new AbstractMap.SimpleEntry<TarantoolServerAddress, List>(serverAddress, (List)connections));
                endpointConnections.add((CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>)connectionFuture);
                continue;
            }
            endpointConnections.add(CompletableFuture.completedFuture(new AbstractMap.SimpleEntry<TarantoolServerAddress, List<TarantoolConnection>>(serverAddress, aliveConnections)));
        }
        return endpointConnections;
    }

    private List<TarantoolConnection> getAliveConnections(TarantoolServerAddress serverAddress) {
        List connections = this.connectionRegistry.get().getOrDefault(serverAddress, Collections.emptyList());
        return connections.stream().filter(TarantoolConnection::isConnected).collect(Collectors.toList());
    }

    private CompletableFuture<List<TarantoolConnection>> establishConnectionsToEndpoint(TarantoolServerAddress serverAddress) {
        List<CompletableFuture> connections = this.connectionFactory.multiConnection(serverAddress.getSocketAddress(), this.config.getConnections()).stream().peek(cf -> cf.thenApply(conn -> {
            conn.addConnectionFailureListener(ex -> {
                this.logger.error("Disconnected from Tarantool server", ex);
                this.connectionMode.set(true);
            });
            return conn;
        })).collect(Collectors.toList());
        return CompletableFuture.allOf(connections.toArray(new CompletableFuture[0])).thenApply(v -> connections.parallelStream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    @Override
    public void close() {
        try {
            this.initLatch.await();
        }
        catch (InterruptedException e) {
            throw new TarantoolClientException("Interrupted while waiting for connection manager initialization");
        }
        this.connectionRegistry.get().values().stream().flatMap(Collection::stream).forEach(conn -> {
            try {
                conn.close();
            }
            catch (Exception e) {
                this.logger.error("Failed to close connection", (Throwable)e);
            }
        });
    }
}

