/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CyclingIterator<T>
implements Iterator<T> {
    private final List<T> items;
    private final int size;
    private final AtomicInteger position = new AtomicInteger(0);

    public CyclingIterator(Collection<T> items) {
        this.items = Collections.synchronizedList(new ArrayList<T>(items));
        this.size = items.size();
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public T next() {
        return this.items.get(this.position.getAndUpdate(p -> (p + 1) % this.size));
    }
}

