/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.netty.channel.Channel;
import io.tarantool.driver.TarantoolVersion;
import io.tarantool.driver.TarantoolVersionHolder;
import io.tarantool.driver.core.RequestFutureManager;
import io.tarantool.driver.core.TarantoolConnection;
import io.tarantool.driver.core.TarantoolConnectionFailureListener;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.protocol.TarantoolRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class TarantoolConnectionImpl
implements TarantoolConnection {
    private final TarantoolVersionHolder versionHolder;
    private final RequestFutureManager requestManager;
    private final Channel channel;
    private final AtomicBoolean connected = new AtomicBoolean(true);
    private final List<TarantoolConnectionFailureListener> failureListeners = new ArrayList<TarantoolConnectionFailureListener>();

    public TarantoolConnectionImpl(RequestFutureManager requestManager, TarantoolVersionHolder versionHolder, Channel channel) {
        this.requestManager = requestManager;
        this.versionHolder = versionHolder;
        this.channel = channel;
        channel.closeFuture().addListener(f -> {
            if (this.connected.compareAndSet(true, false)) {
                for (TarantoolConnectionFailureListener listener : this.failureListeners) {
                    listener.onConnectionFailure(f.cause());
                }
            }
        });
    }

    @Override
    public TarantoolVersion getVersion() throws TarantoolClientException {
        if (!this.isConnected()) {
            throw new TarantoolClientException("Not connected to Tarantool server");
        }
        return this.versionHolder.getVersion();
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public <T> CompletableFuture<T> sendRequest(TarantoolRequest request, MessagePackValueMapper resultMapper) {
        if (!this.isConnected()) {
            throw new TarantoolClientException("Not connected to Tarantool server");
        }
        CompletableFuture requestFuture = this.requestManager.submitRequest(request, resultMapper);
        this.channel.writeAndFlush((Object)request).addListener(f -> {
            if (!f.isSuccess()) {
                requestFuture.completeExceptionally(new RuntimeException("Failed to send the request to Tarantool server", f.cause()));
            }
        });
        return requestFuture;
    }

    @Override
    public void addConnectionFailureListener(TarantoolConnectionFailureListener listener) {
        this.failureListeners.add(listener);
    }

    @Override
    public void close() {
        this.connected.set(false);
        this.requestManager.close();
        this.channel.pipeline().close();
        this.channel.closeFuture().syncUninterruptibly();
    }
}

