/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.ConnectionSelectionStrategy;
import io.tarantool.driver.ConnectionSelectionStrategyFactory;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.core.CyclingIterator;
import io.tarantool.driver.core.TarantoolConnection;
import io.tarantool.driver.core.TarantoolConnectionIterator;
import io.tarantool.driver.exceptions.NoAvailableConnectionsException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public final class TarantoolConnectionSelectionStrategies {

    static final class ParallelRoundRobinStrategy
    implements ConnectionSelectionStrategy {
        private final TarantoolClientConfig config;
        private final CyclingIterator<TarantoolConnectionIterator> iteratorsIterator;
        private final int maxAttempts;

        ParallelRoundRobinStrategy(TarantoolClientConfig config, Collection<TarantoolConnection> connections) {
            this.config = config;
            this.iteratorsIterator = new CyclingIterator<TarantoolConnectionIterator>(this.populateIterators(connections));
            this.maxAttempts = connections.size();
        }

        private Collection<TarantoolConnectionIterator> populateIterators(Collection<TarantoolConnection> connections) {
            int groupSize = this.config.getConnections();
            AtomicInteger currentSize = new AtomicInteger(0);
            return connections.stream().collect(Collectors.groupingBy(conn -> currentSize.getAndIncrement() / groupSize)).values().stream().map(TarantoolConnectionIterator::new).collect(Collectors.toList());
        }

        @Override
        public TarantoolConnection next() throws NoAvailableConnectionsException {
            TarantoolConnection connection = (TarantoolConnection)this.iteratorsIterator.next().next();
            int attempts = 0;
            while (!connection.isConnected() && attempts++ < this.maxAttempts) {
                connection = (TarantoolConnection)this.iteratorsIterator.next().next();
            }
            if (connection.isConnected()) {
                return connection;
            }
            throw new NoAvailableConnectionsException();
        }
    }

    public static enum ParallelRoundRobinStrategyFactory implements ConnectionSelectionStrategyFactory
    {
        INSTANCE;


        @Override
        public ConnectionSelectionStrategy create(TarantoolClientConfig config, Collection<TarantoolConnection> connections) {
            Assert.notNull(connections, (String)"The collection of Tarantool connections should not be null");
            Assert.notEmpty(connections, (String)"The collection of Tarantool connections should not be empty");
            return new ParallelRoundRobinStrategy(config, connections);
        }
    }

    static final class RoundRobinStrategy
    implements ConnectionSelectionStrategy {
        private TarantoolConnectionIterator connectionIterator;
        private final int maxAttempts;

        RoundRobinStrategy(Collection<TarantoolConnection> connections) {
            this.connectionIterator = new TarantoolConnectionIterator(connections);
            this.maxAttempts = connections.size();
        }

        @Override
        public TarantoolConnection next() throws NoAvailableConnectionsException {
            TarantoolConnection connection = (TarantoolConnection)this.connectionIterator.next();
            int attempts = 0;
            while (!connection.isConnected() && attempts++ < this.maxAttempts) {
                connection = (TarantoolConnection)this.connectionIterator.next();
            }
            if (connection.isConnected()) {
                return connection;
            }
            throw new NoAvailableConnectionsException();
        }
    }

    public static enum RoundRobinStrategyFactory implements ConnectionSelectionStrategyFactory
    {
        INSTANCE;


        @Override
        public ConnectionSelectionStrategy create(TarantoolClientConfig config, Collection<TarantoolConnection> connections) {
            Assert.notNull(connections, (String)"The collection of Tarantool connections should not be null");
            Assert.notEmpty(connections, (String)"The collection of Tarantool connections should not be empty");
            return new RoundRobinStrategy(connections);
        }
    }
}

