/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.mappers.AbstractTarantoolResultMapper;
import io.tarantool.driver.mappers.DefaultMessagePackMapper;
import io.tarantool.driver.mappers.DefaultTarantoolTupleValueConverter;
import io.tarantool.driver.mappers.MapperReflectionUtils;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.msgpack.value.ArrayValue;

public abstract class AbstractTarantoolResultMapperFactory {
    protected final MessagePackMapper messagePackMapper;
    protected final Map<Class<?>, MessagePackValueMapper> mapperCache = new ConcurrentHashMap();

    public AbstractTarantoolResultMapperFactory(MessagePackMapper messagePackMapper) {
        this.messagePackMapper = messagePackMapper;
    }

    public AbstractTarantoolResultMapperFactory() {
        this.messagePackMapper = new DefaultMessagePackMapper();
    }

    protected abstract <T> AbstractTarantoolResultMapper<T> createMapper(ValueConverter<ArrayValue, T> var1);

    public AbstractTarantoolResultMapper<TarantoolTuple> withDefaultTupleValueConverter(TarantoolSpaceMetadata spaceMetadata) {
        return this.withConverter(TarantoolTuple.class, new DefaultTarantoolTupleValueConverter(this.messagePackMapper, spaceMetadata));
    }

    public <T> AbstractTarantoolResultMapper<T> withConverter(ValueConverter<ArrayValue, T> valueConverter) {
        return this.withConverter(MapperReflectionUtils.getConverterTargetType(valueConverter), valueConverter);
    }

    public <T> AbstractTarantoolResultMapper<T> withConverter(Class<T> tupleClass, ValueConverter<ArrayValue, T> valueConverter) {
        return (AbstractTarantoolResultMapper)this.mapperCache.computeIfAbsent(tupleClass, c -> this.createMapper(valueConverter));
    }
}

