/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.mappers.ConverterParameterTypeNotFoundException;
import io.tarantool.driver.mappers.DefaultListObjectConverter;
import io.tarantool.driver.mappers.DefaultListValueConverter;
import io.tarantool.driver.mappers.DefaultMapObjectConverter;
import io.tarantool.driver.mappers.DefaultMapValueConverter;
import io.tarantool.driver.mappers.MapperReflectionUtils;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapperException;
import io.tarantool.driver.mappers.MessagePackValueMapperException;
import io.tarantool.driver.mappers.ObjectConverter;
import io.tarantool.driver.mappers.ValueConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.msgpack.value.Value;
import org.springframework.lang.Nullable;

public class DefaultMessagePackMapper
implements MessagePackMapper {
    private Map<String, List<ValueConverter<? extends Value, ?>>> valueConverters = new HashMap();
    private Map<String, List<ObjectConverter<?, ? extends Value>>> objectConverters;
    private Map<String, ValueConverter<? extends Value, ?>> valueConvertersByTarget = new HashMap();
    private Map<String, ObjectConverter<?, ? extends Value>> objectConvertersByTarget;

    public DefaultMessagePackMapper() {
        this.objectConverters = new HashMap();
        this.objectConvertersByTarget = new HashMap();
    }

    public DefaultMessagePackMapper(DefaultMessagePackMapper mapper) {
        this();
        this.valueConverters.putAll(mapper.valueConverters);
        this.objectConverters.putAll(mapper.objectConverters);
        this.valueConvertersByTarget.putAll(mapper.valueConvertersByTarget);
        this.objectConvertersByTarget.putAll(mapper.objectConvertersByTarget);
    }

    @Override
    public <V extends Value, O> V toValue(O o) {
        Function getter = typeName -> this.objectConverters.getOrDefault(typeName, Collections.emptyList()).stream().map(c -> c).filter(c -> c.canConvertObject(o)).findFirst();
        Optional converter = this.findConverter(o.getClass(), getter);
        if (!converter.isPresent()) {
            throw new MessagePackObjectMapperException("ObjectConverter for type %s is not found", o.getClass());
        }
        return (V)((ObjectConverter)converter.get()).toValue(o);
    }

    @Override
    public <V extends Value, O> O fromValue(V v) {
        Function<String, Optional<ValueConverter<V, O>>> getter = typeName -> this.valueConverters.getOrDefault(typeName, Collections.emptyList()).stream().map(c -> c).filter(c -> c.canConvertValue(v)).findFirst();
        return this.fromValue(v, getter);
    }

    @Override
    public <V extends Value, O> O fromValue(V v, Class<O> targetClass) {
        Function<String, Optional<ValueConverter<V, O>>> getter = typeName -> this.valueConverters.getOrDefault(typeName, Collections.emptyList()).stream().map(c -> c).filter(c -> c.canConvertValue(v)).filter(c -> this.checkConverterByTargetType((ValueConverter<? extends Value, ?>)c, targetClass)).findFirst();
        return this.fromValue(v, getter);
    }

    private <V extends Value, O> O fromValue(V v, Function<String, Optional<ValueConverter<V, O>>> getter) {
        Optional converter = this.findConverter(v.getClass(), getter);
        if (!converter.isPresent()) {
            throw new MessagePackValueMapperException("ValueConverter for type %s is not found", v.getClass());
        }
        return ((ValueConverter)converter.get()).fromValue(v);
    }

    @Nullable
    private <T> Optional<T> findConverter(Class<?> objectClass, Function<String, Optional<T>> getter) {
        Optional<T> converter = getter.apply(objectClass.getTypeName());
        if (!converter.isPresent() && objectClass.getSuperclass() != null) {
            converter = this.findConverter(objectClass.getSuperclass(), getter);
        }
        if (!converter.isPresent()) {
            Class<?> iface;
            Class<?>[] classArray = objectClass.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && !(converter = this.findConverter(iface = classArray[i], getter)).isPresent(); ++i) {
            }
        }
        return converter;
    }

    public <V extends Value, O> void registerValueConverter(ValueConverter<V, O> converter) {
        try {
            this.registerValueConverter(MapperReflectionUtils.getInterfaceParameterClass(converter, ValueConverter.class, 0), converter);
        }
        catch (ConverterParameterTypeNotFoundException e) {
            throw new RuntimeException("Failed to determine the source parameter type of the generic interface, try to use the method registerValueConverter(valueClass, objectClass, converter) for registering the converter");
        }
    }

    public <V extends Value, O> void registerValueConverter(Class<V> valueClass, ValueConverter<V, O> converter) {
        try {
            Class objectClass = MapperReflectionUtils.getInterfaceParameterClass(converter, ValueConverter.class, 1);
            this.registerValueConverter(valueClass, objectClass, converter);
        }
        catch (ConverterParameterTypeNotFoundException e) {
            throw new RuntimeException("Failed to determine the target parameter type of the generic interface, try to use the method registerValueConverter(valueClass, objectClass, converter) for registering the converter");
        }
    }

    @Override
    public <V extends Value, O> void registerValueConverter(Class<V> valueClass, Class<O> objectClass, ValueConverter<V, O> converter) {
        List converters = this.valueConverters.computeIfAbsent(valueClass.getTypeName(), k -> new LinkedList());
        converters.add(converter);
        this.valueConvertersByTarget.put(objectClass.getTypeName(), converter);
    }

    private boolean checkConverterByTargetType(ValueConverter<? extends Value, ?> converter, Class<?> targetClass) {
        try {
            return this.valueConvertersByTarget.get(targetClass.getTypeName()) == converter || MapperReflectionUtils.getInterfaceParameterClass(converter, converter.getClass(), 1).isAssignableFrom(targetClass);
        }
        catch (ConverterParameterTypeNotFoundException e) {
            return false;
        }
    }

    @Override
    public <V extends Value, O> Optional<ValueConverter<V, O>> getValueConverter(Class<V> entityClass, Class<O> targetClass) {
        Function getter = typeName -> this.valueConverters.getOrDefault(typeName, Collections.emptyList()).stream().filter(c -> this.checkConverterByTargetType((ValueConverter<? extends Value, ?>)c, targetClass)).map(c -> c).findFirst();
        return this.findConverter(entityClass, getter);
    }

    public <V extends Value, O> void registerObjectConverter(ObjectConverter<O, V> converter) {
        try {
            this.registerObjectConverter(MapperReflectionUtils.getInterfaceParameterClass(converter, ObjectConverter.class, 0), converter);
        }
        catch (ConverterParameterTypeNotFoundException e) {
            throw new RuntimeException("Failed to determine the target parameter type of the generic interface, try to use the method registerObjectConverter(objectClass, valueClass, converter) for registering the converter");
        }
    }

    public <V extends Value, O> void registerObjectConverter(Class<O> objectClass, ObjectConverter<O, V> converter) {
        try {
            Class valueClass = MapperReflectionUtils.getInterfaceParameterClass(converter, ObjectConverter.class, 1);
            this.registerObjectConverter(objectClass, valueClass, converter);
        }
        catch (ConverterParameterTypeNotFoundException e) {
            throw new RuntimeException("Failed to determine the target parameter type of the generic interface, try to use the method registerObjectConverter(objectClass, valueClass, converter) for registering the converter");
        }
    }

    @Override
    public <V extends Value, O> void registerObjectConverter(Class<O> objectClass, Class<V> valueClass, ObjectConverter<O, V> converter) {
        List converters = this.objectConverters.computeIfAbsent(objectClass.getTypeName(), k -> new LinkedList());
        converters.add(converter);
        this.objectConvertersByTarget.put(valueClass.getTypeName(), converter);
    }

    public <V extends Value, O, T extends ValueConverter<V, O> & ObjectConverter<O, V>> void registerConverter(Class<V> valueClass, Class<O> objectClass, T converter) {
        this.registerValueConverter(valueClass, objectClass, converter);
        this.registerObjectConverter(objectClass, valueClass, converter);
    }

    public static class Builder {
        private final DefaultMessagePackMapper mapper;

        public Builder() {
            this.mapper = new DefaultMessagePackMapper();
        }

        public Builder(DefaultMessagePackMapper mapper) {
            this.mapper = new DefaultMessagePackMapper(mapper);
        }

        public Builder withDefaultMapValueConverter() {
            this.mapper.registerValueConverter(new DefaultMapValueConverter(this.mapper));
            return this;
        }

        public Builder withDefaultMapObjectConverter() {
            this.mapper.registerObjectConverter(new DefaultMapObjectConverter(this.mapper));
            return this;
        }

        public Builder withDefaultArrayValueConverter() {
            this.mapper.registerValueConverter(new DefaultListValueConverter(this.mapper));
            return this;
        }

        public Builder withDefaultListObjectConverter() {
            this.mapper.registerObjectConverter(new DefaultListObjectConverter(this.mapper));
            return this;
        }

        public <V extends Value, O, T extends ValueConverter<V, O> & ObjectConverter<O, V>> Builder withConverter(Class<V> valueClass, Class<O> objectClass, T converter) {
            this.mapper.registerConverter(valueClass, objectClass, converter);
            return this;
        }

        public <V extends Value, O> Builder withValueConverter(ValueConverter<V, O> converter) {
            this.mapper.registerValueConverter(converter);
            return this;
        }

        public <V extends Value, O> Builder withValueConverter(Class<V> valueClass, ValueConverter<V, O> converter) {
            this.mapper.registerValueConverter(valueClass, converter);
            return this;
        }

        public <V extends Value, O> Builder withValueConverter(Class<V> valueClass, Class<O> objectClass, ValueConverter<V, O> converter) {
            this.mapper.registerValueConverter(valueClass, objectClass, converter);
            return this;
        }

        public <V extends Value, O> Builder withObjectConverter(ObjectConverter<O, V> converter) {
            this.mapper.registerObjectConverter(converter);
            return this;
        }

        public <V extends Value, O> Builder withObjectConverter(Class<O> objectClass, ObjectConverter<O, V> converter) {
            this.mapper.registerObjectConverter(objectClass, converter);
            return this;
        }

        public <V extends Value, O> Builder withObjectConverter(Class<O> objectClass, Class<V> valueClass, ObjectConverter<O, V> converter) {
            this.mapper.registerObjectConverter(objectClass, valueClass, converter);
            return this;
        }

        public DefaultMessagePackMapper build() {
            return this.mapper;
        }
    }
}

