/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.metadata;

import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.ProxyTarantoolSpaceMetadataContainer;
import io.tarantool.driver.metadata.TarantoolFieldFormatMetadata;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolIndexOptions;
import io.tarantool.driver.metadata.TarantoolIndexPartMetadata;
import io.tarantool.driver.metadata.TarantoolIndexType;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public class ProxyTarantoolSpaceMetadataConverter
implements ValueConverter<ArrayValue, ProxyTarantoolSpaceMetadataContainer> {
    private static final int ID_UNKNOWN = -1;
    private static final ImmutableStringValue SPACE_ID_KEY = new ImmutableStringValueImpl("id");
    private static final ImmutableStringValue SPACE_NAME_KEY = new ImmutableStringValueImpl("name");
    private static final ImmutableStringValue SPACE_FORMAT_KEY = new ImmutableStringValueImpl("_format");
    private static final ImmutableStringValue SPACE_INDEX_KEY = new ImmutableStringValueImpl("index");
    private static final ImmutableStringValue FORMAT_NAME_KEY = new ImmutableStringValueImpl("name");
    private static final ImmutableStringValue FORMAT_TYPE_KEY = new ImmutableStringValueImpl("type");
    private static final ImmutableStringValue INDEX_ID_KEY = new ImmutableStringValueImpl("id");
    private static final ImmutableStringValue INDEX_NAME_KEY = new ImmutableStringValueImpl("name");
    private static final ImmutableStringValue INDEX_UNIQUE_KEY = new ImmutableStringValueImpl("unique");
    private static final ImmutableStringValue INDEX_TYPE_KEY = new ImmutableStringValueImpl("type");
    private static final ImmutableStringValue INDEX_PARTS_KEY = new ImmutableStringValueImpl("parts");
    private static final ImmutableStringValue INDEX_PARTS_FIELD_NO = new ImmutableStringValueImpl("fieldno");
    private static final ImmutableStringValue INDEX_PARTS_TYPE_KEY = new ImmutableStringValueImpl("type");
    private final MessagePackValueMapper mapper;

    public ProxyTarantoolSpaceMetadataConverter(MessagePackValueMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public ProxyTarantoolSpaceMetadataContainer fromValue(ArrayValue value) {
        ProxyTarantoolSpaceMetadataContainer proxyMetadata = new ProxyTarantoolSpaceMetadataContainer();
        Map spacesMap = value.get(0).asMapValue().map();
        String spaceName = (String)this.mapper.fromValue(((Value)spacesMap.get(SPACE_NAME_KEY)).asStringValue());
        int spaceId = (Integer)this.mapper.fromValue(((Value)spacesMap.get(SPACE_ID_KEY)).asIntegerValue());
        TarantoolSpaceMetadata spaceMetadata = new TarantoolSpaceMetadata();
        spaceMetadata.setSpaceId(spaceId);
        spaceMetadata.setOwnerId(-1);
        spaceMetadata.setSpaceName(spaceName);
        List spaceFormat = ((Value)spacesMap.get(SPACE_FORMAT_KEY)).asArrayValue().list();
        spaceMetadata.setSpaceFormatMetadata(this.parseFormat(spaceFormat));
        Value indexesValue = (Value)spacesMap.get(SPACE_INDEX_KEY);
        if (indexesValue.isMapValue() && indexesValue.asMapValue().size() > 0) {
            Map indexes = indexesValue.asMapValue().map();
            proxyMetadata.addIndexes(spaceMetadata.getSpaceName(), this.parseIndexes(indexes));
        }
        proxyMetadata.addSpace(spaceMetadata);
        return proxyMetadata;
    }

    private LinkedHashMap<String, TarantoolFieldFormatMetadata> parseFormat(List<Value> spaceFormat) {
        LinkedHashMap<String, TarantoolFieldFormatMetadata> spaceFormatMetadata = new LinkedHashMap<String, TarantoolFieldFormatMetadata>();
        int fieldPosition = 0;
        for (Value fieldValueMetadata : spaceFormat) {
            Map fieldMap = fieldValueMetadata.asMapValue().map();
            spaceFormatMetadata.put((String)this.mapper.fromValue(((Value)fieldMap.get(FORMAT_NAME_KEY)).asStringValue()), new TarantoolFieldFormatMetadata((String)this.mapper.fromValue(((Value)fieldMap.get(FORMAT_NAME_KEY)).asStringValue()), (String)this.mapper.fromValue(((Value)fieldMap.get(FORMAT_TYPE_KEY)).asStringValue()), fieldPosition));
            ++fieldPosition;
        }
        return spaceFormatMetadata;
    }

    private Map<String, TarantoolIndexMetadata> parseIndexes(Map<Value, Value> indexes) {
        HashMap<String, TarantoolIndexMetadata> indexMetadataMap = new HashMap<String, TarantoolIndexMetadata>();
        for (Map.Entry<Value, Value> indexValueMetadata : indexes.entrySet()) {
            Map indexMap = indexValueMetadata.getValue().asMapValue().map();
            int indexId = (Integer)this.mapper.fromValue(((Value)indexMap.get(INDEX_ID_KEY)).asIntegerValue());
            String indexName = (String)this.mapper.fromValue(((Value)indexMap.get(INDEX_NAME_KEY)).asStringValue());
            String indexType = (String)this.mapper.fromValue(((Value)indexMap.get(INDEX_TYPE_KEY)).asStringValue());
            boolean isUnique = (Boolean)this.mapper.fromValue(((Value)indexMap.get(INDEX_UNIQUE_KEY)).asBooleanValue());
            TarantoolIndexOptions indexOptions = new TarantoolIndexOptions();
            indexOptions.setUnique(isUnique);
            TarantoolIndexMetadata indexMetadata = new TarantoolIndexMetadata();
            indexMetadata.setSpaceId(-1);
            indexMetadata.setIndexId(indexId);
            indexMetadata.setIndexType(TarantoolIndexType.fromString(indexType));
            indexMetadata.setIndexName(indexName);
            indexMetadata.setIndexOptions(indexOptions);
            List indexParts = ((Value)indexMap.get(INDEX_PARTS_KEY)).asArrayValue().list();
            List<TarantoolIndexPartMetadata> indexPartMetadata = indexParts.stream().map(parts -> {
                int fieldNumber = (Integer)this.mapper.fromValue(((Value)parts.asMapValue().map().get(INDEX_PARTS_FIELD_NO)).asIntegerValue());
                String fieldType = (String)this.mapper.fromValue(((Value)parts.asMapValue().map().get(INDEX_PARTS_TYPE_KEY)).asStringValue());
                return new TarantoolIndexPartMetadata(fieldNumber - 1, fieldType);
            }).collect(Collectors.toList());
            indexMetadata.setIndexParts(indexPartMetadata);
            indexMetadataMap.put(indexName, indexMetadata);
        }
        return indexMetadataMap;
    }
}

