/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.metadata;

import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolIndexQuery;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.TarantoolSelectOptions;
import io.tarantool.driver.core.TarantoolConnectionManager;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.TarantoolSimpleResultMapperFactory;
import io.tarantool.driver.mappers.ValueConverter;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolIndexMetadataConverter;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.metadata.TarantoolSpaceMetadataConverter;
import io.tarantool.driver.protocol.TarantoolIteratorType;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.requests.TarantoolSelectRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.msgpack.value.ArrayValue;
import org.springframework.util.Assert;

public class TarantoolMetadata
implements TarantoolMetadataOperations {
    private static final int VSPACE_SPACE_ID = 281;
    private static final int VINDEX_SPACE_ID = 289;
    private final TarantoolSpaceMetadataConverter spaceMetadataMapper;
    private final TarantoolIndexMetadataConverter indexMetadataMapper;
    private final TarantoolClientConfig config;
    private final TarantoolConnectionManager connectionManager;
    private final TarantoolSimpleResultMapperFactory mapperFactory;
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private final Map<Integer, TarantoolSpaceMetadata> spaceMetadataById = new ConcurrentHashMap<Integer, TarantoolSpaceMetadata>();
    private final Map<String, TarantoolSpaceMetadata> spaceMetadata = new ConcurrentHashMap<String, TarantoolSpaceMetadata>();
    private final Map<Integer, Map<String, TarantoolIndexMetadata>> indexMetadata = new ConcurrentHashMap<Integer, Map<String, TarantoolIndexMetadata>>();

    public TarantoolMetadata(TarantoolClientConfig config, TarantoolConnectionManager connectionManager) {
        this.spaceMetadataMapper = new TarantoolSpaceMetadataConverter(config.getMessagePackMapper());
        this.indexMetadataMapper = new TarantoolIndexMetadataConverter(config.getMessagePackMapper());
        this.config = config;
        this.connectionManager = connectionManager;
        this.mapperFactory = new TarantoolSimpleResultMapperFactory(config.getMessagePackMapper());
        this.refresh();
    }

    @Override
    public CompletableFuture<Void> refresh() throws TarantoolClientException {
        CompletableFuture<TarantoolResult<TarantoolSpaceMetadata>> spaces = this.select(281, this.spaceMetadataMapper);
        ((CompletableFuture)spaces.thenApply(result -> {
            this.spaceMetadata.clear();
            this.spaceMetadataById.clear();
            return result;
        })).thenAccept(result -> result.forEach(meta -> {
            this.spaceMetadata.put(meta.getSpaceName(), (TarantoolSpaceMetadata)meta);
            this.spaceMetadataById.put(meta.getSpaceId(), (TarantoolSpaceMetadata)meta);
        }));
        CompletableFuture<TarantoolResult<TarantoolIndexMetadata>> indexes = this.select(289, this.indexMetadataMapper);
        ((CompletableFuture)indexes.thenApply(result -> {
            this.indexMetadata.clear();
            return result;
        })).thenAccept(result -> result.forEach(meta -> {
            this.indexMetadata.putIfAbsent(meta.getSpaceId(), new HashMap());
            this.indexMetadata.get(meta.getSpaceId()).put(meta.getIndexName(), (TarantoolIndexMetadata)meta);
        }));
        return CompletableFuture.allOf(spaces, indexes).whenComplete((v, ex) -> {
            if (this.initLatch.getCount() > 0L) {
                this.initLatch.countDown();
            }
        });
    }

    private <T> CompletableFuture<TarantoolResult<T>> select(int spaceId, ValueConverter<ArrayValue, T> resultMapper) throws TarantoolClientException {
        try {
            TarantoolIndexQuery indexQuery = new TarantoolIndexQuery(0).withIteratorType(TarantoolIteratorType.ITER_ALL);
            TarantoolSelectOptions options = new TarantoolSelectOptions.Builder().build();
            TarantoolSelectRequest request = new TarantoolSelectRequest.Builder().withSpaceId(spaceId).withIndexId(indexQuery.getIndexId()).withIteratorType(indexQuery.getIteratorType()).withKeyValues(indexQuery.getKeyValues()).withLimit(options.getLimit()).withOffset(options.getOffset()).build(this.config.getMessagePackMapper());
            return this.connectionManager.getConnection().sendRequest(request, this.mapperFactory.withConverter((ValueConverter)resultMapper));
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    private Map<Integer, TarantoolSpaceMetadata> getSpaceMetadataById() {
        try {
            this.initLatch.await();
        }
        catch (InterruptedException e) {
            throw new TarantoolClientException(e);
        }
        return this.spaceMetadataById;
    }

    private Map<String, TarantoolSpaceMetadata> getSpaceMetadata() {
        try {
            this.initLatch.await();
        }
        catch (InterruptedException e) {
            throw new TarantoolClientException(e);
        }
        return this.spaceMetadata;
    }

    private Map<Integer, Map<String, TarantoolIndexMetadata>> getIndexMetadata() {
        try {
            this.initLatch.await();
        }
        catch (InterruptedException e) {
            throw new TarantoolClientException(e);
        }
        return this.indexMetadata;
    }

    @Override
    public Optional<TarantoolSpaceMetadata> getSpaceByName(String spaceName) {
        Assert.hasText((String)spaceName, (String)"Space name must not be null or empty");
        return Optional.ofNullable(this.getSpaceMetadata().get(spaceName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexByName(int spaceId, String indexName) {
        Assert.state((spaceId > 0 ? 1 : 0) != 0, (String)"Space ID must be greater than 0");
        Assert.hasText((String)indexName, (String)"Index name must not be null or empty");
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadata().get(spaceId);
        if (metaMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metaMap.get(indexName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexByName(String spaceName, String indexName) {
        Assert.hasText((String)spaceName, (String)"Space name must not be null or empty");
        Assert.hasText((String)indexName, (String)"Index name must not be null or empty");
        TarantoolSpaceMetadata spaceMeta = this.spaceMetadata.get(spaceName);
        if (spaceMeta == null) {
            return Optional.empty();
        }
        Map<String, TarantoolIndexMetadata> metaMap = this.indexMetadata.get(spaceMeta.getSpaceId());
        if (metaMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metaMap.get(indexName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexById(String spaceName, int indexId) {
        Assert.hasText((String)spaceName, (String)"Space name must not be null or empty");
        Assert.state((indexId >= 0 ? 1 : 0) != 0, (String)"Index ID must be greater than or equal 0");
        TarantoolSpaceMetadata spaceMeta = this.spaceMetadata.get(spaceName);
        if (spaceMeta == null) {
            return Optional.empty();
        }
        Map<String, TarantoolIndexMetadata> metaMap = this.indexMetadata.get(spaceMeta.getSpaceId());
        if (metaMap == null) {
            return Optional.empty();
        }
        return metaMap.values().stream().filter(i -> i.getIndexId() == indexId).findFirst();
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexById(int spaceId, int indexId) {
        Assert.state((spaceId > 0 ? 1 : 0) != 0, (String)"Space ID must be greater than 0");
        Assert.state((indexId >= 0 ? 1 : 0) != 0, (String)"Index ID must be greater than or equal 0");
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadata().get(spaceId);
        if (metaMap == null) {
            return Optional.empty();
        }
        return metaMap.values().stream().filter(i -> i.getIndexId() == indexId).findFirst();
    }

    @Override
    public Optional<TarantoolSpaceMetadata> getSpaceById(int spaceId) {
        Assert.state((spaceId > 0 ? 1 : 0) != 0, (String)"Space ID must be greater than 0");
        return Optional.ofNullable(this.getSpaceMetadataById().get(spaceId));
    }
}

