/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol;

import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.mappers.MessagePackValueMapperException;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.value.IntegerValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class TarantoolRequestBody
implements Packable {
    private Map<IntegerValue, Value> values;

    public TarantoolRequestBody() {
        this.values = Collections.emptyMap();
    }

    public TarantoolRequestBody(Map<Integer, ?> body, MessagePackObjectMapper mapper) throws TarantoolProtocolException {
        try {
            this.values = new HashMap<IntegerValue, Value>(body.size(), 1.0f);
            for (Integer key : body.keySet()) {
                this.values.put((IntegerValue)ValueFactory.newInteger((int)key), (Value)mapper.toValue(body.get(key)));
            }
        }
        catch (MessagePackValueMapperException e) {
            throw new TarantoolProtocolException(e);
        }
    }

    @Override
    public Value toMessagePackValue(MessagePackObjectMapper mapper) {
        return ValueFactory.newMap(this.values);
    }
}

