/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol;

import io.tarantool.driver.exceptions.TarantoolDecoderException;
import io.tarantool.driver.protocol.EmptyTarantoolResponseBody;
import io.tarantool.driver.protocol.NotEmptyTarantoolResponseBody;
import io.tarantool.driver.protocol.TarantoolHeader;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolResponseBody;
import io.tarantool.driver.protocol.TarantoolResponseType;
import java.io.IOException;
import java.util.Iterator;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;

public final class TarantoolResponse {
    private final Long syncId;
    private final Long code;
    private final TarantoolResponseBody body;
    private final TarantoolResponseType responseType;

    private TarantoolResponse(Long syncId, Long code, TarantoolResponseBody body) throws TarantoolProtocolException {
        TarantoolResponseType responseType = TarantoolResponseType.fromCode(code);
        switch (responseType) {
            case IPROTO_OK: {
                switch (body.getResponseBodyType()) {
                    case IPROTO_SQL: {
                        throw new UnsupportedOperationException("Tarantool SQL is not supported yet");
                    }
                    case IPROTO_ERROR: {
                        throw new TarantoolProtocolException("Response body first key for IPROTO_OK code must be either IPROTO_DATA or IPROTO_SQL");
                    }
                }
                break;
            }
            case IPROTO_NOT_OK: {
                switch (body.getResponseBodyType()) {
                    case IPROTO_SQL: 
                    case IPROTO_DATA: {
                        throw new TarantoolProtocolException("Response body first key for code other from IPROTO_OK must be only IPROTO_ERROR");
                    }
                }
            }
        }
        this.responseType = responseType;
        this.syncId = syncId;
        this.code = code;
        this.body = body;
    }

    public Long getSyncId() {
        return this.syncId;
    }

    public TarantoolResponseBody getBody() {
        return this.body;
    }

    public TarantoolResponseType getResponseType() {
        return this.responseType;
    }

    public Long getResponseCode() {
        return this.code;
    }

    public static TarantoolResponse fromMessagePack(MessageUnpacker unpacker) throws TarantoolProtocolException {
        TarantoolHeader header = null;
        try {
            header = TarantoolHeader.fromMessagePackValue((Value)unpacker.unpackValue());
            TarantoolResponseBody responseBody = new EmptyTarantoolResponseBody();
            if (unpacker.hasNext()) {
                ImmutableValue bodyMap = unpacker.unpackValue();
                if (!bodyMap.isMapValue()) {
                    throw new TarantoolProtocolException("Response body must be of MP_MAP type");
                }
                MapValue values = bodyMap.asMapValue();
                Iterator it = values.keySet().iterator();
                if (it.hasNext()) {
                    Value key = (Value)it.next();
                    if (!key.isIntegerValue()) {
                        throw new TarantoolProtocolException("Response body first key must be of MP_INT type");
                    }
                    responseBody = new NotEmptyTarantoolResponseBody(key.asIntegerValue().asInt(), (Value)values.map().get(key));
                }
            }
            return new TarantoolResponse(header.getSync(), header.getCode(), responseBody);
        }
        catch (IOException | MessagePackException e) {
            if (header != null) {
                throw new TarantoolDecoderException(header, (Exception)e);
            }
            throw new TarantoolProtocolException((Exception)e);
        }
    }
}

