/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol.requests;

import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequest;
import io.tarantool.driver.protocol.TarantoolRequestBody;
import io.tarantool.driver.protocol.TarantoolRequestFieldType;
import io.tarantool.driver.protocol.TarantoolRequestType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TarantoolCallRequest
extends TarantoolRequest {
    private TarantoolCallRequest(TarantoolRequestBody body) {
        super(TarantoolRequestType.IPROTO_CALL, body);
    }

    public static class Builder {
        Map<Integer, Object> bodyMap = new HashMap<Integer, Object>(2, 1.0f);

        public Builder withFunctionName(String functionName) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_FUNCTION_NAME.getCode(), functionName);
            return this;
        }

        public Builder withArguments(List<Object> arguments) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_TUPLE.getCode(), arguments);
            return this;
        }

        public TarantoolCallRequest build(MessagePackObjectMapper mapper) throws TarantoolProtocolException {
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_FUNCTION_NAME.getCode())) {
                throw new TarantoolProtocolException("Function name must be specified in the call request");
            }
            return new TarantoolCallRequest(new TarantoolRequestBody(this.bodyMap, mapper));
        }
    }
}

