/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol.requests;

import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequest;
import io.tarantool.driver.protocol.TarantoolRequestBody;
import io.tarantool.driver.protocol.TarantoolRequestFieldType;
import io.tarantool.driver.protocol.TarantoolRequestType;
import java.util.HashMap;
import java.util.Map;

public final class TarantoolReplaceRequest
extends TarantoolRequest {
    private TarantoolReplaceRequest(TarantoolRequestBody body) {
        super(TarantoolRequestType.IPROTO_REPLACE, body);
    }

    public static class Builder {
        Map<Integer, Object> bodyMap = new HashMap<Integer, Object>(2, 1.0f);

        public Builder withSpaceId(int spaceId) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_SPACE_ID.getCode(), spaceId);
            return this;
        }

        public Builder withTuple(TarantoolTuple tuple) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_TUPLE.getCode(), tuple.getFields());
            return this;
        }

        public TarantoolReplaceRequest build(MessagePackObjectMapper mapper) throws TarantoolProtocolException {
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_SPACE_ID.getCode())) {
                throw new TarantoolProtocolException("Space ID must be specified in the replace request");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_TUPLE.getCode())) {
                throw new TarantoolProtocolException("Tuple value must be specified for the replace request");
            }
            return new TarantoolReplaceRequest(new TarantoolRequestBody(this.bodyMap, mapper));
        }
    }
}

