/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.proxy;

import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.mappers.TarantoolCallResultMapper;
import io.tarantool.driver.proxy.ProxyOperation;
import java.util.List;
import java.util.concurrent.CompletableFuture;

abstract class AbstractProxyOperation<T>
implements ProxyOperation<T> {
    protected final TarantoolClient client;
    protected final String functionName;
    protected final List<Object> arguments;
    protected final TarantoolCallResultMapper<T> resultMapper;

    AbstractProxyOperation(TarantoolClient client, String functionName, List<Object> arguments, TarantoolCallResultMapper<T> resultMapper) {
        this.client = client;
        this.arguments = arguments;
        this.functionName = functionName;
        this.resultMapper = resultMapper;
    }

    public TarantoolClient getClient() {
        return this.client;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public TarantoolCallResultMapper<T> getResultMapper() {
        return this.resultMapper;
    }

    @Override
    public CompletableFuture<TarantoolResult<T>> execute() {
        return this.client.call(this.functionName, this.arguments, (MessagePackObjectMapper)this.client.getConfig().getMessagePackMapper(), this.resultMapper);
    }
}

