/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.proxy;

import io.tarantool.driver.api.tuple.TarantoolTuple;
import java.util.HashMap;
import java.util.Map;

public final class CRUDOperationOptions {
    public static final String TIME_OUT = "timeout";
    public static final String TUPLES_TO_MAP = "tuples_tomap";
    public static final String SELECT_LIMIT = "limit";
    public static final String SELECT_AFTER = "after";
    public static final String SELECT_BATCH_SIZE = "batch_size";
    private final Integer timeout;
    private final Boolean tuplesAsMap;
    private final Long selectLimit;
    private final Long selectBatchSize;
    private final TarantoolTuple alter;
    private final Map<String, Object> resultMap = new HashMap<String, Object>(5, 1.0f);

    private CRUDOperationOptions(Builder builder) {
        this.timeout = builder.timeout;
        this.tuplesAsMap = builder.tuplesToMap;
        this.selectLimit = builder.selectLimit;
        this.alter = builder.alter;
        this.selectBatchSize = builder.selectBatchSize;
        this.initResultMap();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initResultMap() {
        if (this.timeout != null) {
            this.resultMap.put(TIME_OUT, this.timeout);
        }
        if (this.tuplesAsMap != null) {
            this.resultMap.put(TUPLES_TO_MAP, this.tuplesAsMap);
        }
        if (this.selectLimit != null) {
            this.resultMap.put(SELECT_LIMIT, this.selectLimit);
        }
        if (this.alter != null) {
            this.resultMap.put(SELECT_AFTER, this.alter);
        }
        if (this.selectBatchSize != null) {
            this.resultMap.put(SELECT_BATCH_SIZE, this.selectBatchSize);
        }
    }

    public Map<String, Object> asMap() {
        return this.resultMap;
    }

    public static final class Builder {
        private Integer timeout;
        private Boolean tuplesToMap;
        private Long selectLimit;
        private TarantoolTuple alter;
        private Long selectBatchSize;

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withTuplesToMap(boolean tuplesToMap) {
            this.tuplesToMap = tuplesToMap;
            return this;
        }

        public Builder withSelectLimit(long selectLimit) {
            this.selectLimit = selectLimit;
            return this;
        }

        public Builder withSelectBatchSize(long selectBatchSize) {
            this.selectBatchSize = selectBatchSize;
            return this;
        }

        public Builder withSelectAfter(TarantoolTuple tuple) {
            this.alter = tuple;
            return this;
        }

        public CRUDOperationOptions build() {
            return new CRUDOperationOptions(this);
        }
    }
}

