/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.proxy;

import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.metadata.ProxyTarantoolSpaceMetadataContainer;
import io.tarantool.driver.metadata.ProxyTarantoolSpaceMetadataConverter;
import io.tarantool.driver.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.metadata.TarantoolSpaceMetadata;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.springframework.util.Assert;

public class ProxyTarantoolMetadata
implements TarantoolMetadataOperations {
    private final String getMetadataFunctionName;
    private final TarantoolClient client;
    private final ProxyTarantoolSpaceMetadataConverter metadataConverter;
    private final Map<String, TarantoolSpaceMetadata> spaceMetadata = new ConcurrentHashMap<String, TarantoolSpaceMetadata>();
    private final Map<Integer, TarantoolSpaceMetadata> spaceMetadataById = new ConcurrentHashMap<Integer, TarantoolSpaceMetadata>();
    private final Map<String, Map<String, TarantoolIndexMetadata>> indexMetadata = new ConcurrentHashMap<String, Map<String, TarantoolIndexMetadata>>();
    private final CountDownLatch initLatch = new CountDownLatch(1);

    public ProxyTarantoolMetadata(String getMetadataFunctionName, TarantoolClient client) {
        this.getMetadataFunctionName = getMetadataFunctionName;
        this.client = client;
        this.metadataConverter = new ProxyTarantoolSpaceMetadataConverter(client.getConfig().getMessagePackMapper());
    }

    @Override
    public CompletableFuture<Void> refresh() throws TarantoolClientException {
        CompletableFuture<TarantoolResult<ProxyTarantoolSpaceMetadataContainer>> callResult = this.client.call(this.getMetadataFunctionName, this.metadataConverter);
        return ((CompletableFuture)callResult.thenAccept(result -> {
            this.spaceMetadata.clear();
            this.spaceMetadataById.clear();
            this.indexMetadata.clear();
            result.forEach(sm -> {
                this.spaceMetadata.putAll(sm.getSpaceMetadata());
                sm.getSpaceMetadata().forEach((key, val) -> this.spaceMetadataById.put(val.getSpaceId(), (TarantoolSpaceMetadata)val));
            });
            result.forEach(sm -> this.indexMetadata.putAll(sm.getIndexMetadata()));
        })).whenComplete((v, ex) -> {
            if (this.initLatch.getCount() > 0L) {
                this.initLatch.countDown();
            }
            if (ex != null) {
                throw new TarantoolClientException("CRUD client space metadata refresh error.", (Throwable)ex);
            }
        });
    }

    public Map<String, TarantoolSpaceMetadata> getSpaceMetadata() {
        this.awaitInitLatch();
        return this.spaceMetadata;
    }

    private Map<Integer, TarantoolSpaceMetadata> getSpaceMetadataById() {
        this.awaitInitLatch();
        return this.spaceMetadataById;
    }

    public Map<String, Map<String, TarantoolIndexMetadata>> getIndexMetadata() {
        this.awaitInitLatch();
        return this.indexMetadata;
    }

    @Override
    public Optional<TarantoolSpaceMetadata> getSpaceByName(String spaceName) {
        Assert.hasText((String)spaceName, (String)"Space name must not be null or empty");
        return Optional.ofNullable(this.getSpaceMetadata().get(spaceName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexByName(String spaceName, String indexName) {
        Assert.hasText((String)spaceName, (String)"Space name must not be null or empty");
        Assert.hasText((String)indexName, (String)"Index name must not be null or empty");
        TarantoolSpaceMetadata spaceMeta = this.getSpaceMetadata().get(spaceName);
        if (spaceMeta == null) {
            return Optional.empty();
        }
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadata().get(spaceMeta.getSpaceName());
        if (metaMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metaMap.get(indexName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexById(String spaceName, int indexId) {
        Assert.hasText((String)spaceName, (String)"Space name must not be null or empty");
        Assert.state((indexId >= 0 ? 1 : 0) != 0, (String)"Index ID must be greater than or equal 0");
        TarantoolSpaceMetadata spaceMeta = this.getSpaceMetadata().get(spaceName);
        if (spaceMeta == null) {
            return Optional.empty();
        }
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadata().get(spaceMeta.getSpaceName());
        if (metaMap == null) {
            return Optional.empty();
        }
        return metaMap.values().stream().filter(i -> i.getIndexId() == indexId).findFirst();
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexByName(int spaceId, String indexName) {
        Assert.state((spaceId > 0 ? 1 : 0) != 0, (String)"Space ID must be greater than 0");
        Assert.hasText((String)indexName, (String)"Index name must not be null or empty");
        TarantoolSpaceMetadata spaceMeta = this.getSpaceMetadataById().get(spaceId);
        if (spaceMeta == null) {
            return Optional.empty();
        }
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadata().get(spaceMeta.getSpaceName());
        if (metaMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metaMap.get(indexName));
    }

    @Override
    public Optional<TarantoolIndexMetadata> getIndexById(int spaceId, int indexId) {
        Assert.state((spaceId > 0 ? 1 : 0) != 0, (String)"Space ID must be greater than 0");
        Assert.state((indexId >= 0 ? 1 : 0) != 0, (String)"Index ID must be greater than or equal 0");
        TarantoolSpaceMetadata spaceMeta = this.getSpaceMetadataById().get(spaceId);
        if (spaceMeta == null) {
            return Optional.empty();
        }
        Map<String, TarantoolIndexMetadata> metaMap = this.getIndexMetadata().get(spaceMeta.getSpaceName());
        if (metaMap == null) {
            return Optional.empty();
        }
        return metaMap.values().stream().filter(i -> i.getIndexId() == indexId).findFirst();
    }

    @Override
    public Optional<TarantoolSpaceMetadata> getSpaceById(int spaceId) {
        Assert.state((spaceId > 0 ? 1 : 0) != 0, (String)"Space ID must be greater than 0");
        return Optional.ofNullable(this.getSpaceMetadataById().get(spaceId));
    }

    private void awaitInitLatch() {
        if (this.initLatch.getCount() > 0L) {
            this.refresh();
        }
        try {
            this.initLatch.await();
        }
        catch (InterruptedException e) {
            throw new TarantoolClientException(e);
        }
    }
}

