/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.proxy;

import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolSelectOptions;
import io.tarantool.driver.mappers.TarantoolCallResultMapper;
import io.tarantool.driver.proxy.AbstractProxyOperation;
import io.tarantool.driver.proxy.CRUDOperationOptions;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.Assert;

public final class SelectProxyOperation<T>
extends AbstractProxyOperation<T> {
    private SelectProxyOperation(TarantoolClient client, String functionName, List<Object> arguments, TarantoolCallResultMapper<T> resultMapper) {
        super(client, functionName, arguments, resultMapper);
    }

    public static final class Builder<T> {
        private TarantoolClient client;
        private String spaceName;
        private String functionName;
        private List<?> selectArguments;
        private TarantoolCallResultMapper<T> resultMapper;
        private TarantoolSelectOptions options;

        public Builder<T> withClient(TarantoolClient client) {
            this.client = client;
            return this;
        }

        public Builder<T> withSpaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public Builder<T> withFunctionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder<T> withSelectArguments(List<?> selectArguments) {
            this.selectArguments = selectArguments;
            return this;
        }

        public Builder<T> withSelectOptions(TarantoolSelectOptions options) {
            this.options = options;
            return this;
        }

        public Builder<T> withResultMapper(TarantoolCallResultMapper<T> resultMapper) {
            this.resultMapper = resultMapper;
            return this;
        }

        public SelectProxyOperation<T> build() {
            Assert.notNull((Object)this.client, (String)"Tarantool client should not be null");
            Assert.notNull((Object)this.spaceName, (String)"Tarantool spaceName should not be null");
            Assert.notNull((Object)this.functionName, (String)"Proxy delete function name should not be null");
            Assert.notNull(this.resultMapper, (String)"Result tuple mapper should not be null");
            TarantoolClientConfig config = this.client.getConfig();
            CRUDOperationOptions requestOptions = CRUDOperationOptions.builder().withTimeout(config.getRequestTimeout()).withTuplesToMap(false).withSelectBatchSize(this.options.getLimit()).withSelectLimit(this.options.getLimit()).build();
            List<Object> arguments = Arrays.asList(this.spaceName, this.selectArguments, requestOptions.asMap());
            return new SelectProxyOperation(this.client, this.functionName, arguments, this.resultMapper);
        }
    }
}

