/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.proxy;

import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.mappers.TarantoolCallResultMapper;
import io.tarantool.driver.protocol.operations.TupleOperations;
import io.tarantool.driver.proxy.AbstractProxyOperation;
import io.tarantool.driver.proxy.CRUDOperationOptions;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.Assert;

public final class UpsertProxyOperation<T>
extends AbstractProxyOperation<T> {
    UpsertProxyOperation(TarantoolClient client, String functionName, List<Object> arguments, TarantoolCallResultMapper<T> resultMapper) {
        super(client, functionName, arguments, resultMapper);
    }

    public static final class Builder<T> {
        private TarantoolClient client;
        private String spaceName;
        private String functionName;
        private TarantoolTuple tuple;
        private TupleOperations operations;
        private TarantoolCallResultMapper<T> resultMapper;

        public Builder<T> withClient(TarantoolClient client) {
            this.client = client;
            return this;
        }

        public Builder<T> withSpaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public Builder<T> withFunctionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder<T> withTuple(TarantoolTuple tuple) {
            this.tuple = tuple;
            return this;
        }

        public Builder<T> withTupleOperation(TupleOperations operations) {
            this.operations = operations;
            return this;
        }

        public Builder<T> withResultMapper(TarantoolCallResultMapper<T> resultMapper) {
            this.resultMapper = resultMapper;
            return this;
        }

        public UpsertProxyOperation<T> build() {
            Assert.notNull((Object)this.client, (String)"Tarantool client should not be null");
            Assert.notNull((Object)this.spaceName, (String)"Tarantool spaceName should not be null");
            Assert.notNull((Object)this.functionName, (String)"Proxy delete function name should not be null");
            Assert.notNull((Object)this.tuple, (String)"Tarantool tuple should not be null");
            Assert.notNull((Object)this.operations, (String)"Tarantool tuple operations should not be null");
            Assert.notNull(this.resultMapper, (String)"Result tuple mapper should not be null");
            TarantoolClientConfig config = this.client.getConfig();
            CRUDOperationOptions options = CRUDOperationOptions.builder().withTimeout(config.getRequestTimeout()).withTuplesToMap(false).build();
            List<Object> arguments = Arrays.asList(this.spaceName, this.tuple.getFields(), this.operations.asProxyOperationList(), options.asMap());
            return new UpsertProxyOperation<T>(this.client, this.functionName, arguments, this.resultMapper);
        }
    }
}

