/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.config;

import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolClusterAddressProvider;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.TarantoolServerAddress;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.auth.TarantoolCredentials;
import io.tarantool.driver.core.ClusterTarantoolTupleClient;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.tarantool.config.TarantoolConfigurationSupport;
import org.springframework.data.tarantool.core.DefaultTarantoolExceptionTranslator;
import org.springframework.data.tarantool.core.TarantoolExceptionTranslator;
import org.springframework.data.tarantool.core.TarantoolTemplate;
import org.springframework.data.tarantool.core.convert.MappingTarantoolConverter;
import org.springframework.data.tarantool.core.convert.TarantoolCustomConversions;
import org.springframework.data.tarantool.core.convert.TarantoolMapTypeAliasAccessor;
import org.springframework.data.tarantool.core.mapping.TarantoolMappingContext;
import org.springframework.data.tarantool.core.mapping.TarantoolSimpleTypes;
import org.springframework.data.tarantool.repository.config.TarantoolRepositoryOperationsMapping;

@Configuration(proxyBeanMethods=false)
public abstract class AbstractTarantoolDataConfiguration
extends TarantoolConfigurationSupport {
    @Bean(name={"clusterTarantoolClient"}, destroyMethod="close")
    public TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> tarantoolClient(TarantoolClientConfig tarantoolClientConfig, TarantoolClusterAddressProvider tarantoolClusterAddressProvider) {
        return new ClusterTarantoolTupleClient(tarantoolClientConfig, tarantoolClusterAddressProvider);
    }

    @Bean(value={"tarantoolCredentials"})
    public TarantoolCredentials tarantoolCredentials() {
        return new SimpleTarantoolCredentials();
    }

    @Bean(value={"tarantoolConfig"})
    public TarantoolClientConfig tarantoolClientConfig(TarantoolCredentials tarantoolCredentials) {
        TarantoolClientConfig.Builder builder = new TarantoolClientConfig.Builder().withCredentials(tarantoolCredentials);
        this.configureClientConfig(builder);
        return builder.build();
    }

    protected void configureClientConfig(TarantoolClientConfig.Builder builder) {
    }

    @Bean(value={"tarantoolClusterAddressProvider"})
    public TarantoolClusterAddressProvider tarantoolClusterAddressProvider() {
        return () -> Collections.singletonList(this.tarantoolServerAddress());
    }

    protected TarantoolServerAddress tarantoolServerAddress() {
        return new TarantoolServerAddress();
    }

    @Bean(value={"tarantoolTemplate"})
    public TarantoolTemplate tarantoolTemplate(TarantoolClient tarantoolClient, TarantoolMappingContext mappingContext, MappingTarantoolConverter converter, ForkJoinPool.ForkJoinWorkerThreadFactory queryExecutorsFactory) {
        return new TarantoolTemplate((TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>>)tarantoolClient, mappingContext, converter, queryExecutorsFactory);
    }

    @Bean(value={"tarantoolRepositoryOperationsMapping"})
    public TarantoolRepositoryOperationsMapping tarantoolRepositoryOperationsMapping(TarantoolTemplate tarantoolTemplate) {
        TarantoolRepositoryOperationsMapping baseMapping = new TarantoolRepositoryOperationsMapping(tarantoolTemplate);
        this.configureRepositoryOperationsMapping(baseMapping);
        return baseMapping;
    }

    protected void configureRepositoryOperationsMapping(TarantoolRepositoryOperationsMapping baseMapping) {
    }

    @Bean(value={"mappingTarantoolConverter"})
    public MappingTarantoolConverter mappingTarantoolConverter(TarantoolMappingContext tarantoolMappingContext, TarantoolMapTypeAliasAccessor typeAliasAccessor, TarantoolCustomConversions tarantoolCustomConversions) {
        return new MappingTarantoolConverter(tarantoolMappingContext, typeAliasAccessor, tarantoolCustomConversions);
    }

    @Bean(value={"typeAliasAccessor"})
    public TarantoolMapTypeAliasAccessor typeAliasAccessor() {
        return new TarantoolMapTypeAliasAccessor("_class");
    }

    @Bean(value={"tarantoolMappingContext"})
    public TarantoolMappingContext tarantoolMappingContext() throws ClassNotFoundException {
        TarantoolMappingContext mappingContext = new TarantoolMappingContext();
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        mappingContext.setSimpleTypeHolder(TarantoolSimpleTypes.HOLDER);
        mappingContext.setFieldNamingStrategy(this.fieldNamingStrategy());
        return mappingContext;
    }

    @Bean(value={"tarantoolCustomConversions"})
    public TarantoolCustomConversions customConversions() {
        return new TarantoolCustomConversions(this.customConverters());
    }

    protected List<?> customConverters() {
        return Collections.emptyList();
    }

    @Bean
    public TarantoolExceptionTranslator tarantoolExceptionTranslator() {
        return new DefaultTarantoolExceptionTranslator();
    }

    @Bean
    public ForkJoinPool.ForkJoinWorkerThreadFactory queryExecutorsFactory() {
        return new WorkerFactory();
    }

    private static final class WorkerFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final AtomicLong id = new AtomicLong();

        private WorkerFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName("TarantoolTemplateQueryExecutor-" + this.id);
            return worker;
        }
    }
}

