/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.conditions.Conditions;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.tuple.TarantoolNullField;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.api.tuple.TarantoolTupleResult;
import io.tarantool.driver.api.tuple.operations.TupleOperations;
import io.tarantool.driver.core.tuple.TarantoolTupleImpl;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.converters.ValueConverter;
import io.tarantool.driver.mappers.factories.DefaultMessagePackMapperFactory;
import io.tarantool.driver.mappers.factories.ResultMapperFactoryFactory;
import io.tarantool.driver.mappers.factories.ResultMapperFactoryFactoryImpl;
import io.tarantool.driver.protocol.Packable;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.msgpack.value.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.tarantool.core.DefaultTarantoolExceptionTranslator;
import org.springframework.data.tarantool.core.TarantoolExceptionTranslator;
import org.springframework.data.tarantool.core.TarantoolOperations;
import org.springframework.data.tarantool.core.TarantoolTemplateUtils;
import org.springframework.data.tarantool.core.convert.TarantoolConverter;
import org.springframework.data.tarantool.core.mapping.TarantoolMappingContext;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentEntity;
import org.springframework.data.tarantool.exceptions.TarantoolMetadataMissingException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class BaseTarantoolTemplate
implements TarantoolOperations {
    protected static final int MAX_WORKERS = 4;
    protected final TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> tarantoolClient;
    protected final TarantoolMappingContext mappingContext;
    protected final TarantoolConverter converter;
    protected final TarantoolExceptionTranslator exceptionTranslator;
    protected final ForkJoinPool queryExecutors;
    protected final MessagePackMapper mapper;
    protected final ResultMapperFactoryFactory mapperFactoryFactory;

    BaseTarantoolTemplate(TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> tarantoolClient, TarantoolMappingContext mappingContext, TarantoolConverter converter, ForkJoinPool.ForkJoinWorkerThreadFactory queryExecutorsFactory) {
        this.tarantoolClient = tarantoolClient;
        this.mappingContext = mappingContext;
        this.converter = converter;
        this.queryExecutors = new ForkJoinPool(Math.min(4, Runtime.getRuntime().availableProcessors()), queryExecutorsFactory, null, false);
        this.exceptionTranslator = new DefaultTarantoolExceptionTranslator();
        this.mapper = tarantoolClient.getConfig().getMessagePackMapper();
        this.mapperFactoryFactory = new ResultMapperFactoryFactoryImpl();
    }

    @Override
    public <T> T findOne(Conditions query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        TarantoolResult result = (TarantoolResult)this.executeSync(() -> this.tarantoolClient.space(entity.getSpaceName()).select(query));
        return this.mapFirstToEntity((TarantoolResult<TarantoolTuple>)result, entityClass);
    }

    @Override
    public <T> List<T> find(Conditions query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        TarantoolResult result = (TarantoolResult)this.executeSync(() -> this.tarantoolClient.space(entity.getSpaceName()).select(query));
        return result.stream().map(t -> this.mapToEntity(t, entityClass)).collect(Collectors.toList());
    }

    @Override
    public <T, ID> T findById(ID id, Class<T> entityClass) {
        Assert.notNull(id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        TarantoolResult result = (TarantoolResult)this.executeSync(() -> {
            Conditions query = this.idQueryFromObject(id, entityClass).withLimit(1L);
            return this.tarantoolClient.space(entity.getSpaceName()).select(query);
        });
        return this.mapFirstToEntity((TarantoolResult<TarantoolTuple>)result, entityClass);
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        TarantoolResult result = (TarantoolResult)this.executeSync(() -> this.tarantoolClient.space(entity.getSpaceName()).select(Conditions.any()));
        return result.stream().map(t -> this.mapToEntity(t, entityClass)).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> findAndRemove(Conditions query, Class<T> entityType) {
        List<T> entities = this.find(query, entityType);
        return entities.stream().map(e -> this.remove(e, entityType)).collect(Collectors.toList());
    }

    @Override
    public <T> Long count(Conditions query, Class<T> entityType) {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public <T> T insert(T entity, Class<T> entityClass) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        TarantoolPersistentEntity entityMetadata = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        TarantoolResult result = (TarantoolResult)this.executeSync(() -> this.tarantoolClient.space(entityMetadata.getSpaceName()).insert((Packable)this.mapToTuple(entity, entityMetadata)));
        return this.mapFirstToEntity((TarantoolResult<TarantoolTuple>)result, entityClass);
    }

    @Override
    public <T> T save(T entity, Class<T> entityClass) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        TarantoolPersistentEntity entityMetadata = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        TarantoolResult result = (TarantoolResult)this.executeSync(() -> this.tarantoolClient.space(entityMetadata.getSpaceName()).replace((Packable)this.mapToTuple(entity, entityMetadata)));
        return this.mapFirstToEntity((TarantoolResult<TarantoolTuple>)result, entityClass);
    }

    @Override
    public <T> List<T> update(Conditions query, T entity, Class<T> entityClass) {
        TarantoolPersistentEntity entityMetadata = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        TarantoolTuple newTuple = this.mapToTuple(entity, entityMetadata);
        return this.update(query, this.setNonNullFieldsFromTuple(newTuple), entityClass);
    }

    @Override
    public <T> T remove(T entity, Class<T> entityClass) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Conditions query = this.idQueryFromEntity(entity);
        return this.removeInternal(query, entityClass);
    }

    @Override
    public <T, ID> T removeById(ID id, Class<T> entityClass) {
        Assert.notNull(id, (String)"ID must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Conditions query = this.idQueryFromObject(id, entityClass);
        return this.removeInternal(query, entityClass);
    }

    @Override
    public void truncate(String spaceName) {
        this.executeSync(() -> this.tarantoolClient.space(spaceName).truncate());
    }

    @Override
    public TarantoolConverter getConverter() {
        return this.converter;
    }

    @Override
    public TarantoolMappingContext getMappingContext() {
        return this.mappingContext;
    }

    protected <T> Conditions idQueryFromEntity(T source) {
        TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getPersistentEntity(source.getClass());
        Assert.notNull((Object)entity, (String)("Failed to get entity class for " + source.getClass()));
        Object idValue = entity.getIdentifierAccessor(source).getRequiredIdentifier();
        List<?> indexPartValues = TarantoolTemplateUtils.getIndexPartValues(idValue, entity);
        return this.createIndexEqualsConditionFromParts(indexPartValues);
    }

    protected <T> Conditions idQueryFromObject(T source, Class<?> entityClass) {
        TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        Assert.notNull((Object)entity, (String)("Failed to get entity class for " + entityClass + ". Possibly @Tuple annotation is missing on the class."));
        List<?> indexPartValues = TarantoolTemplateUtils.getIndexPartValues(source, entity);
        return this.createIndexEqualsConditionFromParts(indexPartValues);
    }

    protected <T> List<T> update(Conditions query, TupleOperations updateOperations, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Conditions must not be null!");
        Assert.notNull((Object)updateOperations, (String)"Update operations must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        TarantoolPersistentEntity entityMetadata = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        TarantoolResult tuplesForUpdate = (TarantoolResult)this.executeSync(() -> this.tarantoolClient.space(entityMetadata.getSpaceName()).select(query));
        List futures = tuplesForUpdate.stream().map(tuple -> this.tarantoolClient.space(entityMetadata.getSpaceName()).update(TarantoolTemplateUtils.idQueryFromTuple(tuple, entityMetadata), updateOperations)).collect(Collectors.toList());
        return (List)this.getFutureValue(this.queryExecutors.submit(() -> ((Stream)futures.stream().parallel()).map(this::getFutureValue).map(tuples -> this.mapFirstToEntity((TarantoolResult<TarantoolTuple>)tuples, entityClass)).collect(Collectors.toList())));
    }

    protected TupleOperations setNonNullFieldsFromTuple(TarantoolTuple tuple) {
        AtomicReference result = new AtomicReference();
        TupleOperations.fromTarantoolTuple((TarantoolTuple)tuple).asList().stream().filter(o -> !(o.getValue() instanceof TarantoolNullField)).forEach(op -> {
            if (result.get() == null) {
                result.set(TupleOperations.set((int)op.getFieldIndex(), (Object)op.getValue()));
            } else {
                ((TupleOperations)result.get()).addOperation(op);
            }
        });
        return (TupleOperations)result.get();
    }

    @Nullable
    protected <T> T removeInternal(Conditions query, Class<T> entityClass) {
        TarantoolPersistentEntity entityMetadata = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        TarantoolResult result = (TarantoolResult)this.executeSync(() -> this.tarantoolClient.space(entityMetadata.getSpaceName()).delete(query));
        return this.mapFirstToEntity((TarantoolResult<TarantoolTuple>)result, entityClass);
    }

    protected <T> TarantoolTuple mapToTuple(T entity, TarantoolPersistentEntity<?> entityMetadata) {
        Optional spaceMetadata = this.tarantoolClient.metadata().getSpaceByName(entityMetadata.getSpaceName());
        TarantoolTupleImpl tuple = spaceMetadata.isPresent() ? new TarantoolTupleImpl(this.getMessagePackMapper(), (TarantoolSpaceMetadata)spaceMetadata.get()) : new TarantoolTupleImpl(this.getMessagePackMapper());
        this.getConverter().write(entity, tuple);
        return tuple;
    }

    protected <R> R executeSync(Supplier<CompletableFuture<R>> func) {
        return this.getFutureValue((Future)func.get());
    }

    protected <R> R getFutureValue(Future<R> future) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            DataAccessException wrapped;
            if (e.getCause() instanceof RuntimeException && (wrapped = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)e.getCause())) != null) {
                throw wrapped;
            }
            throw new DataRetrievalFailureException(e.getMessage(), e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T, R extends List<T>> Supplier<CompletableFuture<R>> getResultSupplier(String functionName, List<?> parameters, String spaceName, Class<T> entityClass) {
        return () -> this.tarantoolClient.call(functionName, this.mapParameters(parameters), (MessagePackObjectMapper)this.getMessagePackMapper(), this.getResultMapperForEntity(spaceName, entityClass)).thenApply(result -> result == null ? null : result.stream().map(t -> this.mapToEntity(t, entityClass)).collect(Collectors.toList()));
    }

    protected <T, R extends List<T>> Supplier<CompletableFuture<R>> getCustomResultSupplier(String functionName, List<?> parameters, MessagePackObjectMapper parameterMapper, ValueConverter<Value, T> contentConverter) {
        ValueConverter & Serializable converter = (ValueConverter & Serializable)v -> v.isNilValue() ? null : v.asArrayValue().list().stream().map(arg_0 -> ((ValueConverter)contentConverter).fromValue(arg_0)).collect(Collectors.toList());
        return () -> this.tarantoolClient.callForSingleResult(functionName, this.mapParameters(parameters), parameterMapper, converter);
    }

    protected <T> ValueConverter<Value, List<T>> getListValueConverter(Class<T> entityClass) {
        return (ValueConverter & Serializable)result -> result == null ? null : result.asArrayValue().list().stream().map(v -> this.mapToEntity(this.mapper.fromValue(v, Map.class), entityClass)).collect(Collectors.toList());
    }

    protected <T> CallResultMapper<TarantoolTupleResult, SingleValueCallResult<TarantoolTupleResult>> getResultMapperForEntity(String spaceName, Class<T> entityClass) {
        TarantoolPersistentEntity entityMetadata = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        String name = StringUtils.hasText((String)spaceName) ? spaceName : entityMetadata.getSpaceName();
        Optional spaceMetadata = this.tarantoolClient.metadata().getSpaceByName(name);
        if (!spaceMetadata.isPresent() && !entityClass.equals(Void.TYPE)) {
            throw new TarantoolMetadataMissingException(name);
        }
        return this.mapperFactoryFactory.createMapper(this.mapper).buildSingleValueResultMapper((MessagePackValueMapper)this.mapperFactoryFactory.createMapper(this.mapper, (TarantoolSpaceMetadata)spaceMetadata.orElse(null)).withArrayValueToTarantoolTupleResultConverter().withRowsMetadataToTarantoolTupleResultConverter().buildCallResultMapper((MessagePackMapper)DefaultMessagePackMapperFactory.getInstance().emptyMapper()), TarantoolTupleResult.class);
    }

    protected <T> T mapFirstToEntity(TarantoolResult<TarantoolTuple> tuples, Class<T> entityClass) {
        return this.mapToEntity(tuples.stream().findFirst().orElse(null), entityClass);
    }

    protected <T> T mapToEntity(@Nullable Object tuple, Class<T> entityClass) {
        return (T)this.getConverter().read(entityClass, tuple);
    }

    protected Conditions createIndexEqualsConditionFromParts(List<?> indexPartValues) {
        List<?> indexPartValuesConverted = this.mapParameters(indexPartValues);
        return Conditions.indexEquals((int)0, indexPartValuesConverted);
    }

    protected List<?> mapParameters(List<?> parameters) {
        LinkedList mappedParameters = new LinkedList();
        this.getConverter().write(parameters, mappedParameters);
        return mappedParameters;
    }

    protected MessagePackMapper getMessagePackMapper() {
        return this.tarantoolClient.getConfig().getMessagePackMapper();
    }
}

