/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core;

import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolException;
import io.tarantool.driver.exceptions.TarantoolFunctionCallException;
import io.tarantool.driver.exceptions.TarantoolInternalException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.data.tarantool.core.TarantoolExceptionTranslator;

public class DefaultTarantoolExceptionTranslator
implements TarantoolExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException cause) {
        if (cause instanceof TarantoolException) {
            if (cause instanceof TarantoolClientException || cause instanceof TarantoolFunctionCallException) {
                return new InvalidDataAccessResourceUsageException(cause.getMessage(), (Throwable)cause);
            }
            if (cause instanceof TarantoolInternalException) {
                return new DataRetrievalFailureException(cause.getMessage(), (Throwable)cause);
            }
            return new RecoverableDataAccessException(cause.getMessage(), (Throwable)cause);
        }
        return null;
    }
}

